/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.debugger.ida.event;

import com.github.unidbg.Emulator;
import com.github.unidbg.debugger.ida.DebuggerEvent;
import com.github.unidbg.debugger.ida.Utils;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;

public class LoadExecutableEvent
extends DebuggerEvent {
    @Override
    public byte[] pack(Emulator<?> emulator) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.put(Utils.pack_dd(2L));
        buffer.put(Utils.pack_dd(1L));
        buffer.put(Utils.pack_dd(emulator.getPid()));
        buffer.put(Utils.pack_dd(emulator.getPid()));
        UnidbgPointer pc = emulator.getContext().getPCPointer();
        if (emulator.is32Bit()) {
            buffer.put(Utils.pack_dq(pc.toUIntPeer() + 1L));
        } else {
            buffer.put(Utils.pack_dq(pc.peer + 1L));
        }
        buffer.put((byte)1);
        Utils.writeCString(buffer, "unidbg");
        buffer.put(Utils.pack_dq(1L));
        buffer.put(Utils.pack_dq(emulator.getPageAlign() + 1));
        buffer.put(Utils.pack_dq(1L));
        return Utils.flipBuffer(buffer);
    }
}

