/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.file;

import com.github.unidbg.file.NewFileIO;

public class FileResult<T extends NewFileIO> {
    private static final int FALLBACK_ERRNO = -1;
    public final T io;
    public final int errno;

    public static <T extends NewFileIO> FileResult<T> success(T io) {
        if (io == null) {
            throw new NullPointerException("io is null");
        }
        return new FileResult<T>(io, 0);
    }

    public static <T extends NewFileIO> FileResult<T> failed(int errno) {
        if (errno == 0) {
            throw new IllegalArgumentException("errno=" + errno);
        }
        return new FileResult<Object>(null, errno);
    }

    public static <T extends NewFileIO> FileResult<T> fallback(T io) {
        if (io == null) {
            throw new NullPointerException("io is null");
        }
        return new FileResult<T>(io, -1);
    }

    public boolean isSuccess() {
        return this.io != null && this.errno == 0;
    }

    public boolean isFallback() {
        return this.io != null && this.errno == -1;
    }

    private FileResult(T io, int errno) {
        this.io = io;
        this.errno = errno;
    }
}

