/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.hook.hookzz;

import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.Svc;
import com.github.unidbg.Symbol;
import com.github.unidbg.arm.Arm64Svc;
import com.github.unidbg.arm.ArmSvc;
import com.github.unidbg.arm.context.RegisterContext;
import com.github.unidbg.hook.BaseHook;
import com.github.unidbg.hook.ReplaceCallback;
import com.github.unidbg.hook.hookzz.Arm64HookEntryInfo;
import com.github.unidbg.hook.hookzz.ArmHookEntryInfo;
import com.github.unidbg.hook.hookzz.HookZzArm32RegisterContextImpl;
import com.github.unidbg.hook.hookzz.HookZzArm64RegisterContextImpl;
import com.github.unidbg.hook.hookzz.IHookZz;
import com.github.unidbg.hook.hookzz.InstrumentCallback;
import com.github.unidbg.hook.hookzz.WrapCallback;
import com.github.unidbg.memory.SvcMemory;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Pointer;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class HookZz
extends BaseHook
implements IHookZz {
    private static final Log log = LogFactory.getLog(HookZz.class);
    private static final int RS_SUCCESS = 1;
    private final Symbol zz_enable_arm_arm64_b_branch;
    private final Symbol zz_disable_arm_arm64_b_branch;
    private final Symbol zzReplace;
    private final Symbol zzWrap;
    private final Symbol zzDynamicBinaryInstrumentation;

    public static HookZz getInstance(Emulator<?> emulator) {
        HookZz hookZz = (HookZz)emulator.get(HookZz.class.getName());
        if (hookZz == null) {
            hookZz = new HookZz(emulator);
            emulator.set(HookZz.class.getName(), hookZz);
        }
        return hookZz;
    }

    private HookZz(Emulator<?> emulator) {
        super(emulator, "libhookzz");
        boolean isIOS = emulator.getFamily() == Family.iOS;
        this.zz_enable_arm_arm64_b_branch = this.module.findSymbolByName(isIOS ? "_zz_enable_arm_arm64_b_branch" : "zz_enable_arm_arm64_b_branch", false);
        this.zz_disable_arm_arm64_b_branch = this.module.findSymbolByName(isIOS ? "_zz_disable_arm_arm64_b_branch" : "zz_disable_arm_arm64_b_branch", false);
        this.zzReplace = this.module.findSymbolByName(isIOS ? "_ZzReplace" : "ZzReplace", false);
        this.zzWrap = this.module.findSymbolByName(isIOS ? "_ZzWrap" : "ZzWrap", false);
        this.zzDynamicBinaryInstrumentation = this.module.findSymbolByName(isIOS ? "_ZzDynamicBinaryInstrumentation" : "ZzDynamicBinaryInstrumentation", false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("zzReplace=" + this.zzReplace + ", zzWrap=" + this.zzWrap));
        }
        if (this.zz_enable_arm_arm64_b_branch == null) {
            throw new IllegalStateException("zz_enable_arm_arm64_b_branch is null");
        }
        if (this.zz_disable_arm_arm64_b_branch == null) {
            throw new IllegalStateException("zz_disable_arm_arm64_b_branch is null");
        }
        if (this.zzReplace == null) {
            throw new IllegalStateException("zzReplace is null");
        }
        if (this.zzWrap == null) {
            throw new IllegalStateException("zzWrap is null");
        }
        if (this.zzDynamicBinaryInstrumentation == null) {
            throw new IllegalStateException("zzDynamicBinaryInstrumentation is null");
        }
    }

    @Override
    public void enable_arm_arm64_b_branch() {
        int ret = this.zz_enable_arm_arm64_b_branch.call(this.emulator, new Object[0]).intValue();
        if (ret != 1) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void disable_arm_arm64_b_branch() {
        int ret = this.zz_disable_arm_arm64_b_branch.call(this.emulator, new Object[0]).intValue();
        if (ret != 1) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback) {
        this.replace(functionAddress, callback, false);
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback) {
        this.replace(symbol, callback, false);
    }

    @Override
    public void replace(long functionAddress, Svc svc) {
        if (svc == null) {
            throw new NullPointerException();
        }
        UnidbgPointer originCall = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        UnidbgPointer callback = this.emulator.getSvcMemory().registerSvc(svc);
        int ret = this.zzReplace.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), callback, originCall).intValue();
        if (ret != 1) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void replace(Symbol symbol, Svc svc) {
        this.replace(symbol.getAddress(), svc);
    }

    @Override
    public void replace(long functionAddress, ReplaceCallback callback, boolean enablePostCall) {
        UnidbgPointer originCall = this.emulator.getMemory().malloc(this.emulator.getPointerSize(), false).getPointer();
        Pointer replaceCall = this.createReplacePointer(callback, originCall, enablePostCall);
        int ret = this.zzReplace.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), replaceCall, originCall).intValue();
        if (ret != 1) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void replace(Symbol symbol, ReplaceCallback callback, boolean enablePostCall) {
        this.replace(symbol.getAddress(), callback, enablePostCall);
    }

    @Override
    public <T extends RegisterContext> void wrap(Symbol symbol, WrapCallback<T> callback) {
        this.wrap(symbol.getAddress(), callback);
    }

    @Override
    public <T extends RegisterContext> void wrap(long functionAddress, final WrapCallback<T> callback) {
        SvcMemory svcMemory = this.emulator.getSvcMemory();
        final Stack context = new Stack();
        UnidbgPointer preCall = svcMemory.registerSvc(this.emulator.is32Bit() ? new ArmSvc(){

            @Override
            public long handle(Emulator<?> emulator) {
                callback.preCall(emulator, new HookZzArm32RegisterContextImpl(emulator, context), new ArmHookEntryInfo(emulator));
                return 0L;
            }
        } : new Arm64Svc(){

            @Override
            public long handle(Emulator<?> emulator) {
                callback.preCall(emulator, new HookZzArm64RegisterContextImpl(emulator, context), new Arm64HookEntryInfo(emulator));
                return 0L;
            }
        });
        UnidbgPointer postCall = svcMemory.registerSvc(this.emulator.is32Bit() ? new ArmSvc(){

            @Override
            public long handle(Emulator<?> emulator) {
                callback.postCall(emulator, new HookZzArm32RegisterContextImpl(emulator, context), new ArmHookEntryInfo(emulator));
                return 0L;
            }
        } : new Arm64Svc(){

            @Override
            public long handle(Emulator<?> emulator) {
                callback.postCall(emulator, new HookZzArm64RegisterContextImpl(emulator, context), new Arm64HookEntryInfo(emulator));
                return 0L;
            }
        });
        int ret = this.zzWrap.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), preCall, postCall).intValue();
        if (ret != 1) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public <T extends RegisterContext> void instrument(Symbol symbol, InstrumentCallback<T> callback) {
        this.instrument(symbol.getAddress(), callback);
    }

    @Override
    public <T extends RegisterContext> void instrument(long functionAddress, final InstrumentCallback<T> callback) {
        SvcMemory svcMemory = this.emulator.getSvcMemory();
        UnidbgPointer dbiCall = svcMemory.registerSvc(this.emulator.is32Bit() ? new ArmSvc(){
            private final Stack<Object> context = new Stack();

            @Override
            public long handle(Emulator<?> emulator) {
                callback.dbiCall(emulator, new HookZzArm32RegisterContextImpl(emulator, this.context), new ArmHookEntryInfo(emulator));
                return 0L;
            }
        } : new Arm64Svc(){
            private final Stack<Object> context = new Stack();

            @Override
            public long handle(Emulator<?> emulator) {
                callback.dbiCall(emulator, new HookZzArm64RegisterContextImpl(emulator, this.context), new Arm64HookEntryInfo(emulator));
                return 0L;
            }
        });
        int ret = this.zzDynamicBinaryInstrumentation.call(this.emulator, UnidbgPointer.pointer(this.emulator, functionAddress), dbiCall).intValue();
        if (ret != 1) {
            throw new IllegalStateException("ret=" + ret);
        }
    }

    @Override
    public void switch_to_file_log(String path) {
        throw new UnsupportedOperationException();
    }
}

