/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.pointer;

import com.github.unidbg.Emulator;
import com.github.unidbg.PointerArg;
import com.github.unidbg.pointer.UnidbgPointer;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public abstract class UnidbgStructure
extends Structure
implements PointerArg {
    private static final Pointer PLACEHOLDER_MEMORY = new UnidbgPointer(null, null){

        @Override
        public UnidbgPointer share(long offset, long sz) {
            return this;
        }
    };
    private static final Field FIELD_STRUCT_FIELDS;

    public static int calculateSize(Class<? extends UnidbgStructure> type) {
        try {
            Constructor<? extends UnidbgStructure> constructor = type.getConstructor(Pointer.class);
            return constructor.newInstance(PLACEHOLDER_MEMORY).calculateSize(false);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    protected UnidbgStructure(Emulator<?> emulator, byte[] data) {
        this(new ByteArrayPointer(emulator, data));
    }

    protected UnidbgStructure(byte[] data) {
        this(null, data);
    }

    protected UnidbgStructure(Pointer p) {
        super(p);
        this.checkPointer(p);
    }

    private void checkPointer(Pointer p) {
        if (p == null) {
            throw new NullPointerException("p is null");
        }
        if (!(p instanceof UnidbgPointer) && !this.isPlaceholderMemory(p)) {
            throw new IllegalArgumentException("p is NOT UnidbgPointer");
        }
    }

    protected int getNativeSize(Class<?> nativeType, Object value) {
        if (Pointer.class.isAssignableFrom(nativeType)) {
            throw new UnsupportedOperationException();
        }
        return super.getNativeSize(nativeType, value);
    }

    protected int getNativeAlignment(Class<?> type, Object value, boolean isFirstElement) {
        if (Pointer.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException();
        }
        return super.getNativeAlignment(type, value, isFirstElement);
    }

    private boolean isPlaceholderMemory(Pointer p) {
        return "native@0x0".equals(p.toString());
    }

    public void pack() {
        super.write();
    }

    public void unpack() {
        super.read();
    }

    public String toString(boolean debug) {
        return this.toString(0, true, debug);
    }

    private String format(Class<?> type) {
        String s = type.getName();
        int dot = s.lastIndexOf(".");
        return s.substring(dot + 1);
    }

    private String toString(int indent, boolean showContents, boolean dumpMemory) {
        this.ensureAllocated();
        String LS = System.getProperty("line.separator");
        String name = this.format(this.getClass()) + "(" + this.getPointer() + ")";
        if (!(this.getPointer() instanceof Memory)) {
            name = name + " (" + this.size() + " bytes)";
        }
        StringBuilder prefix = new StringBuilder();
        for (int idx = 0; idx < indent; ++idx) {
            prefix.append("  ");
        }
        StringBuilder contents = new StringBuilder(LS);
        if (!showContents) {
            contents = new StringBuilder("...}");
        } else {
            Iterator<Structure.StructField> i = this.fields().values().iterator();
            while (i.hasNext()) {
                Structure.StructField sf = i.next();
                Object value = this.getFieldValue(sf.field);
                String type = this.format(sf.type);
                String index = "";
                contents.append((CharSequence)prefix);
                if (sf.type.isArray() && value != null) {
                    type = this.format(sf.type.getComponentType());
                    index = "[" + Array.getLength(value) + "]";
                }
                contents.append(String.format("  %s %s%s@0x%X", type, sf.name, index, sf.offset));
                if (value instanceof UnidbgStructure) {
                    value = ((UnidbgStructure)value).toString(indent + 1, !(value instanceof Structure.ByReference), dumpMemory);
                }
                contents.append("=");
                if (value instanceof Long) {
                    contents.append(String.format("0x%08X", value));
                } else if (value instanceof Integer) {
                    contents.append(String.format("0x%04X", value));
                } else if (value instanceof Short) {
                    contents.append(String.format("0x%02X", value));
                } else if (value instanceof Byte) {
                    contents.append(String.format("0x%01X", value));
                } else if (value instanceof byte[]) {
                    contents.append(Hex.encodeHexString((byte[])((byte[])value)));
                } else {
                    contents.append(String.valueOf(value).trim());
                }
                contents.append(LS);
                if (i.hasNext()) continue;
                contents.append((CharSequence)prefix).append("}");
            }
        }
        if (indent == 0 && dumpMemory) {
            int BYTES_PER_ROW = 4;
            contents.append(LS).append("memory dump").append(LS);
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            for (int i = 0; i < buf.length; ++i) {
                if (i % 4 == 0) {
                    contents.append("[");
                }
                if (buf[i] >= 0 && buf[i] < 16) {
                    contents.append("0");
                }
                contents.append(Integer.toHexString(buf[i] & 0xFF));
                if (i % 4 != 3 || i >= buf.length - 1) continue;
                contents.append("]").append(LS);
            }
            contents.append("]");
        }
        return name + " {" + contents;
    }

    private Object getFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception e) {
            throw new Error("Exception reading field '" + field.getName() + "' in " + this.getClass(), e);
        }
    }

    private Map<String, Structure.StructField> fields() {
        try {
            return (Map)FIELD_STRUCT_FIELDS.get(this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        try {
            FIELD_STRUCT_FIELDS = Structure.class.getDeclaredField("structFields");
            FIELD_STRUCT_FIELDS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ByteArrayPointer
    extends UnidbgPointer {
        private final Emulator<?> emulator;
        private final byte[] data;

        public ByteArrayPointer(Emulator<?> emulator, byte[] data) {
            super(emulator, data);
            this.emulator = emulator;
            this.data = data;
        }

        @Override
        public UnidbgPointer share(long offset, long sz) {
            if (offset == 0L) {
                return this;
            }
            if (offset > 0L && offset + sz < (long)this.data.length) {
                if (sz == 0L) {
                    sz = (long)this.data.length - offset;
                }
                byte[] tmp = new byte[(int)sz];
                System.arraycopy(this.data, (int)offset, tmp, 0, (int)sz);
                return new ByteArrayPointer(this.emulator, tmp);
            }
            throw new UnsupportedOperationException("offset=0x" + Long.toHexString(offset) + ", sz=" + sz);
        }
    }
}

