/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.spi;

import com.github.unidbg.Alignment;
import com.github.unidbg.Emulator;
import com.github.unidbg.LibraryResolver;
import com.github.unidbg.Module;
import com.github.unidbg.ModuleListener;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.file.NewFileIO;
import com.github.unidbg.hook.HookListener;
import com.github.unidbg.memory.MMapListener;
import com.github.unidbg.memory.Memory;
import com.github.unidbg.memory.MemoryMap;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.spi.LibraryFile;
import com.github.unidbg.spi.Loader;
import com.github.unidbg.unix.UnixSyscallHandler;
import com.sun.jna.Pointer;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLoader<T extends NewFileIO>
implements Memory,
Loader {
    private static final Log log = LogFactory.getLog(AbstractLoader.class);
    protected final Backend backend;
    protected final Emulator<T> emulator;
    protected final UnixSyscallHandler<T> syscallHandler;
    protected long sp;
    protected long mmapBaseAddress;
    protected final Map<Long, MemoryMap> memoryMap = new TreeMap<Long, MemoryMap>();
    protected MMapListener mMapListener;
    protected boolean callInitFunction = true;
    protected final List<HookListener> hookListeners = new ArrayList<HookListener>();
    protected LibraryResolver libraryResolver;
    private long stackBase;
    protected int stackSize;
    protected final List<ModuleListener> moduleListeners = new ArrayList<ModuleListener>();

    @Override
    public void setMMapListener(MMapListener listener) {
        this.mMapListener = listener;
    }

    protected void setMMapBaseAddress(long address) {
        this.mmapBaseAddress = address;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMMapBaseAddress=0x" + Long.toHexString(address)));
        }
    }

    public AbstractLoader(Emulator<T> emulator, UnixSyscallHandler<T> syscallHandler) {
        this.backend = emulator.getBackend();
        this.emulator = emulator;
        this.syscallHandler = syscallHandler;
        this.setMMapBaseAddress(0x40000000L);
    }

    @Override
    public Collection<MemoryMap> getMemoryMap() {
        return this.memoryMap.values();
    }

    @Override
    public final UnidbgPointer mmap(int length, int prot) {
        int aligned = (int)ARM.alignSize(length, this.emulator.getPageAlign());
        long addr = this.mmap2(0L, aligned, prot, 0, -1, 0);
        UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, addr);
        assert (pointer != null);
        return pointer.setSize(aligned);
    }

    protected final long allocateMapAddress(long mask, long length) {
        Map.Entry<Long, MemoryMap> lastEntry = null;
        for (Map.Entry<Long, MemoryMap> entry : this.memoryMap.entrySet()) {
            if (lastEntry == null) {
                lastEntry = entry;
                continue;
            }
            MemoryMap map = lastEntry.getValue();
            long mmapAddress = map.base + map.size;
            if (mmapAddress + length < entry.getKey() && (mmapAddress & mask) == 0L) {
                return mmapAddress;
            }
            lastEntry = entry;
        }
        if (lastEntry != null) {
            MemoryMap map = (MemoryMap)lastEntry.getValue();
            long mmapAddress = map.base + map.size;
            if (mmapAddress < this.mmapBaseAddress) {
                log.debug((Object)("allocateMapAddress mmapBaseAddress=0x" + Long.toHexString(this.mmapBaseAddress) + ", mmapAddress=0x" + Long.toHexString(mmapAddress)));
                this.setMMapBaseAddress(mmapAddress);
            }
        }
        long addr = this.mmapBaseAddress;
        while ((addr & mask) != 0L) {
            addr += (long)this.emulator.getPageAlign();
        }
        this.setMMapBaseAddress(addr + length);
        return addr;
    }

    @Override
    public final int munmap(long start, int length) {
        MemoryMap removed;
        int aligned = (int)ARM.alignSize(length, this.emulator.getPageAlign());
        this.backend.mem_unmap(start, aligned);
        if (this.mMapListener != null) {
            this.mMapListener.onUnmap(start, aligned);
        }
        if ((removed = this.memoryMap.remove(start)) == null) {
            MemoryMap segment = null;
            for (Map.Entry<Long, MemoryMap> entry : this.memoryMap.entrySet()) {
                MemoryMap map = entry.getValue();
                if (start <= entry.getKey() || start >= map.base + map.size) continue;
                segment = entry.getValue();
                break;
            }
            if (segment == null || segment.size < (long)aligned) {
                throw new IllegalStateException("munmap aligned=0x" + Long.toHexString(aligned) + ", start=0x" + Long.toHexString(start));
            }
            if (start + (long)aligned < segment.base + segment.size) {
                long newSize = segment.base + segment.size - start - (long)aligned;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("munmap aligned=0x" + Long.toHexString(aligned) + ", start=0x" + Long.toHexString(start) + ", base=0x" + Long.toHexString(start + (long)aligned) + ", size=" + newSize));
                }
                if (this.memoryMap.put(start + (long)aligned, new MemoryMap(start + (long)aligned, (int)newSize, segment.prot)) != null) {
                    log.warn((Object)("munmap replace exists memory map addr=0x" + Long.toHexString(start + (long)aligned)));
                }
            }
            if (this.memoryMap.put(segment.base, new MemoryMap(segment.base, (int)(start - segment.base), segment.prot)) == null) {
                log.warn((Object)("munmap replace failed warning: addr=0x" + Long.toHexString(segment.base)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("munmap aligned=0x" + Long.toHexString(aligned) + ", start=0x" + Long.toHexString(start) + ", base=0x" + Long.toHexString(segment.base) + ", size=" + (start - segment.base)));
            }
            return segment.prot;
        }
        if (removed.size != (long)aligned) {
            if ((long)aligned >= removed.size) {
                MemoryMap remove;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("munmap removed=0x" + Long.toHexString(removed.size) + ", aligned=0x" + Long.toHexString(aligned) + ", start=0x" + Long.toHexString(start)));
                }
                long address = start + removed.size;
                for (long size = (long)aligned - removed.size; size != 0L; size -= remove.size) {
                    remove = this.memoryMap.remove(address);
                    if (removed.prot != remove.prot) {
                        throw new IllegalStateException();
                    }
                    address += remove.size;
                }
                return removed.prot;
            }
            if (this.memoryMap.put(start + (long)aligned, new MemoryMap(start + (long)aligned, removed.size - (long)aligned, removed.prot)) != null) {
                log.warn((Object)("munmap replace exists memory map addr=0x" + Long.toHexString(start + (long)aligned)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("munmap removed=0x" + Long.toHexString(removed.size) + ", aligned=0x" + Long.toHexString(aligned) + ", base=0x" + Long.toHexString(start + (long)aligned) + ", size=" + (removed.size - (long)aligned)));
            }
            return removed.prot;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("munmap aligned=0x" + Long.toHexString(aligned) + ", start=0x" + Long.toHexString(start) + ", base=0x" + Long.toHexString(removed.base) + ", size=" + removed.size));
        }
        if (this.memoryMap.isEmpty()) {
            this.setMMapBaseAddress(0x40000000L);
        }
        return removed.prot;
    }

    @Override
    public final int mprotect(long address, int length, int prot) {
        if (address % 4096L != 0L) {
            this.setErrno(22);
            return -1;
        }
        if (this.mMapListener != null) {
            prot = this.mMapListener.onProtect(address, length, prot);
        }
        this.backend.mem_protect(address, length, prot);
        MemoryMap map = this.memoryMap.get(address);
        if (map != null && map.size == (long)length) {
            map.prot = prot;
        }
        return 0;
    }

    @Override
    public final Module load(File elfFile) {
        return this.load(elfFile, false);
    }

    @Override
    public final Module load(LibraryFile libraryFile) {
        return this.load(libraryFile, false);
    }

    @Override
    public final Module load(File elfFile, boolean forceCallInit) {
        return this.loadInternal(this.createLibraryFile(elfFile), forceCallInit);
    }

    protected abstract LibraryFile createLibraryFile(File var1);

    @Override
    public final Module load(LibraryFile libraryFile, boolean forceCallInit) {
        return this.loadInternal(libraryFile, forceCallInit);
    }

    protected abstract Module loadInternal(LibraryFile var1, boolean var2);

    @Override
    public final void disableCallInitFunction() {
        this.callInitFunction = false;
    }

    @Override
    public void setCallInitFunction(boolean callInit) {
        this.callInitFunction = callInit;
    }

    @Override
    public final void addHookListener(HookListener listener) {
        this.hookListeners.add(listener);
    }

    @Override
    public void setLibraryResolver(LibraryResolver libraryResolver) {
        libraryResolver.onSetToLoader(this.emulator);
        this.libraryResolver = libraryResolver;
    }

    @Override
    public final UnidbgPointer allocateStack(int size) {
        this.setStackPoint(this.sp - (long)size);
        UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, this.sp);
        assert (pointer != null);
        return pointer.setSize(size);
    }

    @Override
    public final UnidbgPointer writeStackString(String str) {
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        return this.writeStackBytes(Arrays.copyOf(data, data.length + 1));
    }

    @Override
    public final UnidbgPointer writeStackBytes(byte[] data) {
        int size = ARM.alignSize(data.length);
        UnidbgPointer pointer = this.allocateStack(size);
        assert (pointer != null);
        pointer.write(0L, data, 0, data.length);
        return pointer;
    }

    @Override
    public final UnidbgPointer pointer(long address) {
        return UnidbgPointer.pointer(this.emulator, address);
    }

    @Override
    public long getStackBase() {
        return this.stackBase;
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }

    @Override
    public final void setStackPoint(long sp) {
        if (this.sp == 0L) {
            this.stackBase = sp;
        }
        this.sp = sp;
        if (this.emulator.is32Bit()) {
            this.backend.reg_write(12, sp);
        } else {
            this.backend.reg_write(4, sp);
        }
    }

    @Override
    public long getStackPoint() {
        return this.sp;
    }

    @Override
    public final void addModuleListener(ModuleListener listener) {
        this.moduleListeners.add(listener);
    }

    protected final void notifyModuleLoaded(Module module) {
        for (ModuleListener listener : this.moduleListeners) {
            listener.onLoaded(this.emulator, module);
        }
    }

    protected final void dump(Pointer pointer, long size, File outFile) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
            int dump = 0;
            while ((long)dump < size) {
                long read = size - (long)dump;
                if (read > 4096L) {
                    read = 4096L;
                }
                byte[] data = pointer.getByteArray((long)dump, (int)read);
                outputStream.write(data);
                dump = (int)((long)dump + read);
            }
        }
    }

    protected final Alignment mem_map(long address, long size, int prot, String libraryName, long align) {
        Alignment alignment = ARM.align(address, size, align);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + libraryName + "]0x" + Long.toHexString(alignment.address) + " - 0x" + Long.toHexString(alignment.address + alignment.size) + ", size=0x" + Long.toHexString(alignment.size) + ", prot=" + prot));
        }
        this.backend.mem_map(alignment.address, alignment.size, prot);
        if (this.mMapListener != null) {
            this.mMapListener.onMap(alignment.address, alignment.size, prot);
        }
        if (this.memoryMap.put(alignment.address, new MemoryMap(alignment.address, (int)alignment.size, prot)) != null) {
            log.warn((Object)("mem_map replace exists memory map address=" + Long.toHexString(alignment.address)));
        }
        return alignment;
    }

    @Override
    public final Module findModuleByAddress(long address) {
        for (Module module : this.getLoadedModules()) {
            long base = this.getModuleBase(module);
            if (address < base || address >= base + module.size) continue;
            return module;
        }
        return null;
    }

    protected long getModuleBase(Module module) {
        return module.base;
    }

    @Override
    public final Module findModule(String name) {
        for (Module module : this.getLoadedModules()) {
            if (!module.name.equals(name)) continue;
            return module;
        }
        return null;
    }

    @Override
    public Module loadVirtualModule(String name, Map<String, UnidbgPointer> symbols) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        out.writeLong(this.sp);
        out.writeLong(this.mmapBaseAddress);
        out.writeLong(this.stackBase);
        out.writeLong(this.stackSize);
        out.writeInt(this.memoryMap.size());
        for (Map.Entry<Long, MemoryMap> entry : this.memoryMap.entrySet()) {
            MemoryMap map = entry.getValue();
            out.writeLong(entry.getKey());
            map.serialize(out);
            UnidbgPointer pointer = UnidbgPointer.pointer(this.emulator, map.base);
            assert (pointer != null);
            byte[] data = pointer.getByteArray(0L, (int)map.size);
            out.write(data);
        }
    }
}

