/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.thread;

import com.github.unidbg.Emulator;
import com.github.unidbg.signal.SigSet;
import com.github.unidbg.signal.SignalTask;
import com.github.unidbg.thread.BaseTask;
import com.github.unidbg.thread.Task;
import com.github.unidbg.thread.Waiter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class AbstractTask
extends BaseTask
implements Task {
    protected final int id;
    private SigSet sigMaskSet;
    private SigSet sigPendingSet;
    private final List<SignalTask> signalTaskList = new ArrayList<SignalTask>();

    public AbstractTask(int id) {
        this.id = id;
    }

    @Override
    public SigSet getSigMaskSet() {
        return this.sigMaskSet;
    }

    @Override
    public SigSet getSigPendingSet() {
        return this.sigPendingSet;
    }

    @Override
    public void setSigMaskSet(SigSet sigMaskSet) {
        this.sigMaskSet = sigMaskSet;
    }

    @Override
    public void setSigPendingSet(SigSet sigPendingSet) {
        this.sigPendingSet = sigPendingSet;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final void addSignalTask(SignalTask task) {
        this.signalTaskList.add(task);
        Waiter waiter = this.getWaiter();
        if (waiter != null) {
            waiter.onSignal(task);
        }
    }

    @Override
    public void removeSignalTask(SignalTask task) {
        this.signalTaskList.remove(task);
    }

    @Override
    public List<SignalTask> getSignalTaskList() {
        return this.signalTaskList.isEmpty() ? Collections.emptyList() : new ArrayList<SignalTask>(this.signalTaskList);
    }

    @Override
    public boolean setErrno(Emulator<?> emulator, int errno) {
        return false;
    }

    @Override
    protected final String getStatus() {
        if (this.isFinish()) {
            return "Finished";
        }
        if (this.canDispatch()) {
            return "Runnable";
        }
        return "Paused";
    }
}

