/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.thread;

import com.github.unidbg.AbstractEmulator;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.ARM;
import com.github.unidbg.arm.FunctionCall;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.memory.MemoryBlock;
import com.github.unidbg.pointer.UnidbgPointer;
import com.github.unidbg.thread.DestroyListener;
import com.github.unidbg.thread.RunnableTask;
import com.github.unidbg.thread.Waiter;
import java.util.Stack;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTask
implements RunnableTask {
    private static final Log log = LogFactory.getLog(BaseTask.class);
    private Waiter waiter;
    private long context;
    public static final int THREAD_STACK_SIZE = 524288;
    private MemoryBlock stackBlock;
    private DestroyListener destroyListener;
    private final Stack<FunctionCall> stack = new Stack();
    private final Bag<Long> bag = new HashBag();

    @Override
    public void setWaiter(Emulator<?> emulator, Waiter waiter) {
        this.waiter = waiter;
        if (waiter != null && log.isTraceEnabled()) {
            emulator.attach().debug();
        }
    }

    @Override
    public Waiter getWaiter() {
        return this.waiter;
    }

    @Override
    public final boolean canDispatch() {
        if (this.waiter != null) {
            return this.waiter.canDispatch();
        }
        return true;
    }

    @Override
    public final boolean isContextSaved() {
        return this.context != 0L;
    }

    @Override
    public final void saveContext(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.context == 0L) {
            this.context = backend.context_alloc();
        }
        backend.context_save(this.context);
    }

    @Override
    public void popContext(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        int off = emulator.popContext();
        long pc = emulator.is32Bit() ? (long)backend.reg_read(11).intValue() & 0xFFFFFFFEL : backend.reg_read(260).longValue();
        backend.reg_write(emulator.is32Bit() ? 11 : 260, pc + (long)off);
        this.saveContext(emulator);
    }

    @Override
    public void restoreContext(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        backend.context_restore(this.context);
    }

    protected final Number continueRun(AbstractEmulator<?> emulator, long until) {
        Waiter waiter;
        long pc;
        Backend backend = emulator.getBackend();
        backend.context_restore(this.context);
        if (emulator.is32Bit()) {
            pc = (long)backend.reg_read(11).intValue() & 0xFFFFFFFEL;
            if (ARM.isThumb(backend)) {
                pc |= 1L;
            }
        } else {
            pc = backend.reg_read(260).longValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("continue run task=" + this + ", pc=" + UnidbgPointer.pointer(emulator, pc) + ", until=0x" + Long.toHexString(until)));
        }
        if ((waiter = this.getWaiter()) != null) {
            waiter.onContinueRun(emulator);
            this.setWaiter(emulator, null);
        }
        return emulator.emulate(pc, until);
    }

    @Override
    public void destroy(Emulator<?> emulator) {
        Backend backend = emulator.getBackend();
        if (this.stackBlock != null) {
            this.stackBlock.free();
            this.stackBlock = null;
        }
        if (this.context != 0L) {
            backend.context_free(this.context);
            this.context = 0L;
        }
        if (this.destroyListener != null) {
            this.destroyListener.onDestroy(emulator);
        }
    }

    protected final UnidbgPointer allocateStack(Emulator<?> emulator) {
        if (this.stackBlock == null) {
            this.stackBlock = emulator.getMemory().malloc(524288, true);
        }
        return this.stackBlock.getPointer().share(524288L, 0L);
    }

    @Override
    public void setResult(Emulator<?> emulator, Number ret) {
    }

    @Override
    public void setDestroyListener(DestroyListener listener) {
        this.destroyListener = listener;
    }

    @Override
    public void pushFunction(Emulator<?> emulator, FunctionCall call) {
        this.stack.push(call);
        this.bag.add((Object)call.returnAddress, 1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("pushFunction call=" + call.toReadableString(emulator) + ", bagCount=" + this.bag.getCount((Object)call.returnAddress)));
        }
    }

    @Override
    public FunctionCall popFunction(Emulator<?> emulator, long address) {
        FunctionCall call;
        if (!this.bag.contains((Object)address)) {
            return null;
        }
        if (emulator.is64Bit()) {
            call = this.stack.peek();
            long lr = emulator.getContext().getLR();
            if (lr != call.returnAddress) {
                return null;
            }
            this.bag.remove((Object)address, 1);
            this.stack.pop();
        } else {
            this.bag.remove((Object)address, 1);
            call = this.stack.pop();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("popFunction call=" + call.toReadableString(emulator) + ", address=" + UnidbgPointer.pointer(emulator, address) + ", stackSize=" + this.stack.size() + ", bagCount=" + this.bag.getCount((Object)address)));
        }
        if (call.returnAddress != address) {
            for (FunctionCall fc : this.stack) {
                log.warn((Object)("stackCall call=" + fc.toReadableString(emulator) + ", bagCount=" + this.bag.getCount((Object)fc.returnAddress)));
            }
        }
        return call;
    }

    public final String toString() {
        return this.getStatus() + "|" + this.toThreadString();
    }

    protected abstract String getStatus();

    protected abstract String toThreadString();
}

