/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.BlockHook;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.DebugHook;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.FastBackend;
import com.github.unidbg.arm.backend.InterruptHook;
import com.github.unidbg.arm.backend.InterruptHookNotifier;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.arm.backend.dynarmic.Dynarmic;
import com.github.unidbg.arm.backend.dynarmic.DynarmicCallback;
import com.github.unidbg.arm.backend.dynarmic.DynarmicException;
import com.github.unidbg.arm.backend.dynarmic.EventMemHookNotifier;
import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DynarmicBackend
extends FastBackend
implements Backend,
DynarmicCallback {
    private static final Log log = LogFactory.getLog(DynarmicBackend.class);
    protected final Dynarmic dynarmic;
    private static final int EXCEPTION_BREAKPOINT = 8;
    protected long until;
    private EventMemHookNotifier eventMemHookNotifier;
    protected InterruptHookNotifier interruptHookNotifier;

    protected DynarmicBackend(Emulator<?> emulator, Dynarmic dynarmic) throws BackendException {
        super(emulator);
        this.dynarmic = dynarmic;
        try {
            this.dynarmic.setDynarmicCallback(this);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    @Override
    public void handleExceptionRaised(long pc, int exception) {
        if (exception == 8) {
            this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, 0);
            return;
        }
        try {
            this.emulator.attach().debug();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleMemoryReadFailed(long vaddr, int size) {
        if (this.eventMemHookNotifier != null) {
            this.eventMemHookNotifier.handleMemoryReadFailed(this, vaddr, size);
        }
    }

    @Override
    public void handleMemoryWriteFailed(long vaddr, int size) {
        if (this.eventMemHookNotifier != null) {
            this.eventMemHookNotifier.handleMemoryWriteFailed(this, vaddr, size);
        }
    }

    public final void switchUserMode() {
    }

    public final void enableVFP() {
    }

    public final synchronized void emu_start(long begin, long until, long timeout, long count) throws BackendException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("emu_start begin=0x" + Long.toHexString(begin) + ", until=0x" + Long.toHexString(until) + ", timeout=" + timeout + ", count=" + count));
        }
        this.until = until + 4L;
        try {
            this.dynarmic.emu_start(begin);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void emu_stop() throws BackendException {
        try {
            this.dynarmic.emu_stop();
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void destroy() {
        IOUtils.close((Closeable)this.dynarmic);
    }

    public byte[] mem_read(long address, long size) throws BackendException {
        try {
            return this.dynarmic.mem_read(address, (int)size);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void mem_write(long address, byte[] bytes) throws BackendException {
        try {
            this.dynarmic.mem_write(address, bytes);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void mem_map(long address, long size, int perms) throws BackendException {
        try {
            this.dynarmic.mem_map(address, size, perms);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void mem_protect(long address, long size, int perms) throws BackendException {
        try {
            this.dynarmic.mem_protect(address, size, perms);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void mem_unmap(long address, long size) throws BackendException {
        try {
            this.dynarmic.mem_unmap(address, size);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void hook_add_new(EventMemHook callback, int type, Object user_data) {
        if (this.eventMemHookNotifier != null) {
            throw new IllegalStateException();
        }
        this.eventMemHookNotifier = new EventMemHookNotifier(callback, type, user_data);
    }

    public void hook_add_new(InterruptHook callback, Object user_data) {
        if (this.interruptHookNotifier != null) {
            throw new IllegalStateException();
        }
        this.interruptHookNotifier = new InterruptHookNotifier(callback, user_data);
    }

    public void hook_add_new(CodeHook callback, long begin, long end, Object user_data) {
        throw new UnsupportedOperationException();
    }

    public void debugger_add(DebugHook callback, long begin, long end, Object user_data) {
    }

    public void hook_add_new(ReadHook callback, long begin, long end, Object user_data) {
        throw new UnsupportedOperationException();
    }

    public void hook_add_new(WriteHook callback, long begin, long end, Object user_data) {
        throw new UnsupportedOperationException();
    }

    public void hook_add_new(BlockHook callback, long begin, long end, Object user_data) {
        throw new UnsupportedOperationException();
    }

    public void context_restore(long context) {
        throw new UnsupportedOperationException();
    }

    public void context_save(long context) {
        throw new UnsupportedOperationException();
    }

    public long context_alloc() {
        throw new UnsupportedOperationException();
    }
}

