/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.arm.backend.dynarmic.Dynarmic;
import com.github.unidbg.arm.backend.dynarmic.DynarmicBackend32;
import com.github.unidbg.arm.backend.dynarmic.DynarmicBackend64;
import java.io.IOException;
import org.scijava.nativelib.NativeLoader;

public class DynarmicFactory
extends BackendFactory {
    public DynarmicFactory(boolean fallbackUnicorn) {
        super(fallbackUnicorn);
    }

    protected Backend newBackendInternal(Emulator<?> emulator, boolean is64Bit) {
        Dynarmic dynarmic = new Dynarmic(is64Bit);
        return is64Bit ? new DynarmicBackend64(emulator, dynarmic) : new DynarmicBackend32(emulator, dynarmic);
    }

    static {
        try {
            NativeLoader.loadLibrary((String)"dynarmic", (String[])new String[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

