/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.dynarmic;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.DynarmicBackend;
import com.github.unidbg.arm.backend.dynarmic.Dynarmic;
import com.github.unidbg.arm.backend.dynarmic.DynarmicException;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynarmicBackend64
extends DynarmicBackend {
    private static final Log log = LogFactory.getLog(DynarmicBackend64.class);

    public DynarmicBackend64(Emulator<?> emulator, Dynarmic dynarmic) {
        super(emulator, dynarmic);
    }

    @Override
    public boolean handleInterpreterFallback(long pc, int num_instructions) {
        try {
            this.emulator.attach().debug();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void callSVC(long pc, int swi) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("callSVC pc=0x" + Long.toHexString(pc) + ", swi=" + swi));
        }
        if (pc == this.until) {
            this.emu_stop();
            return;
        }
        this.interruptHookNotifier.notifyCallSVC((Backend)this, 2, swi);
    }

    public Number reg_read(int regId) throws BackendException {
        try {
            switch (regId) {
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    return this.dynarmic.reg_read64(regId - 199);
                }
                case 4: {
                    return this.dynarmic.reg_read_sp64();
                }
                case 1: {
                    return this.dynarmic.reg_read64(29);
                }
                case 2: {
                    return this.dynarmic.reg_read64(30);
                }
                case 260: {
                    return this.dynarmic.reg_read_pc64();
                }
                case 3: {
                    return this.dynarmic.reg_read_nzcv();
                }
            }
            throw new DynarmicException("regId=" + regId);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void reg_write(int regId, Number value) throws BackendException {
        try {
            switch (regId) {
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.dynarmic.reg_write64(regId - 199, value.longValue());
                    break;
                }
                case 4: {
                    this.dynarmic.reg_set_sp64(value.longValue());
                    break;
                }
                case 2: {
                    this.dynarmic.reg_write64(30, value.longValue());
                    break;
                }
                case 262: {
                    this.dynarmic.reg_set_tpidr_el0(value.longValue());
                    break;
                }
                case 263: {
                    this.dynarmic.reg_set_tpidrro_el0(value.longValue());
                    break;
                }
                case 3: {
                    this.dynarmic.reg_set_nzcv(value.longValue());
                    break;
                }
                default: {
                    throw new DynarmicException("regId=" + regId);
                }
            }
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public byte[] reg_read_vector(int regId) throws BackendException {
        try {
            if (regId >= 104 && regId <= 135) {
                return this.dynarmic.reg_read_vector(regId - 104);
            }
            throw new UnsupportedOperationException("regId=" + regId);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void reg_write_vector(int regId, byte[] vector) throws BackendException {
        try {
            if (vector.length != 16) {
                throw new IllegalStateException("Invalid vector size");
            }
            if (regId < 104 || regId > 135) {
                throw new UnsupportedOperationException("regId=" + regId);
            }
            this.dynarmic.reg_set_vector(regId - 104, vector);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    protected byte[] addSoftBreakPoint(long address, int svcNumber, boolean thumb) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
            KeystoneEncoded encoded = keystone.assemble("brk #" + svcNumber);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }
}

