/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.dynarmic;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.DynarmicBackend;
import com.github.unidbg.arm.backend.dynarmic.Dynarmic;
import com.github.unidbg.arm.backend.dynarmic.DynarmicException;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynarmicBackend32
extends DynarmicBackend {
    private static final Log log = LogFactory.getLog(DynarmicBackend32.class);

    public DynarmicBackend32(Emulator<?> emulator, Dynarmic dynarmic) {
        super(emulator, dynarmic);
    }

    @Override
    public void callSVC(long pc, int swi) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("callSVC pc=0x" + Long.toHexString(pc) + ", swi=" + swi));
        }
        if (pc == this.until) {
            this.emu_stop();
            return;
        }
        this.interruptHookNotifier.notifyCallSVC((Backend)this, 2, swi);
    }

    public Number reg_read(int regId) throws BackendException {
        try {
            switch (regId) {
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    return this.dynarmic.reg_read32(regId - 66);
                }
                case 12: {
                    return this.dynarmic.reg_read32(13);
                }
                case 10: {
                    return this.dynarmic.reg_read32(14);
                }
                case 11: {
                    return this.dynarmic.reg_read32(15);
                }
                case 3: {
                    return this.dynarmic.reg_read_cpsr();
                }
            }
            throw new DynarmicException("regId=" + regId);
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void reg_write(int regId, Number value) throws BackendException {
        try {
            switch (regId) {
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.dynarmic.reg_write32(regId - 66, value.intValue());
                    break;
                }
                case 12: {
                    this.dynarmic.reg_write32(13, value.intValue());
                    break;
                }
                case 10: {
                    this.dynarmic.reg_write32(14, value.intValue());
                    break;
                }
                case 113: {
                    this.dynarmic.reg_write_c13_c0_3(value.intValue());
                    break;
                }
                case 3: {
                    this.dynarmic.reg_write_cpsr(value.intValue());
                    break;
                }
                default: {
                    throw new DynarmicException("regId=" + regId);
                }
            }
        }
        catch (DynarmicException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public byte[] reg_read_vector(int regId) throws BackendException {
        return null;
    }

    public void reg_write_vector(int regId, byte[] vector) throws BackendException {
        throw new UnsupportedOperationException();
    }

    protected byte[] addSoftBreakPoint(long address, int svcNumber, boolean thumb) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, thumb ? KeystoneMode.ArmThumb : KeystoneMode.Arm);){
            KeystoneEncoded encoded = keystone.assemble("bkpt #" + svcNumber);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }
}

