/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.dynarmic;

import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.EventMemHook;

public class EventMemHookNotifier {
    private final EventMemHook callback;
    private final int type;
    private final Object user_data;

    public EventMemHookNotifier(EventMemHook callback, int type, Object user_data) {
        this.callback = callback;
        this.type = type;
        this.user_data = user_data;
    }

    public void handleMemoryReadFailed(Backend backend, long vaddr, int size) {
        if ((this.type & 0x10) != 0) {
            this.callback.hook(backend, vaddr, size, 0L, this.user_data, EventMemHook.UnmappedType.Read);
        }
    }

    public void handleMemoryWriteFailed(Backend backend, long vaddr, int size) {
        if ((this.type & 0x20) != 0) {
            this.callback.hook(backend, vaddr, size, 0L, this.user_data, EventMemHook.UnmappedType.Write);
        }
    }
}

