/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendFactory;
import com.github.unidbg.arm.backend.hypervisor.Hypervisor;
import com.github.unidbg.arm.backend.hypervisor.HypervisorBackend64;
import java.io.IOException;
import org.scijava.nativelib.NativeLoader;

public class HypervisorFactory
extends BackendFactory {
    public HypervisorFactory(boolean fallbackUnicorn) {
        super(fallbackUnicorn);
    }

    protected Backend newBackendInternal(Emulator<?> emulator, boolean is64Bit) {
        Hypervisor hypervisor = new Hypervisor(is64Bit);
        if (is64Bit) {
            return new HypervisorBackend64(emulator, hypervisor);
        }
        throw new UnsupportedOperationException();
    }

    static {
        try {
            NativeLoader.loadLibrary((String)"hypervisor", (String[])new String[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

