/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.hypervisor;

import com.github.unidbg.arm.backend.hypervisor.HypervisorCallback;
import com.github.unidbg.arm.backend.hypervisor.HypervisorException;
import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Hypervisor
implements Closeable {
    private static final Log log = LogFactory.getLog(Hypervisor.class);
    public static final long REG_VBAR_EL1 = 0xF0000000L;
    public static final long PSTATE$SS = 0x200000L;
    private final long nativeHandle;
    private static Hypervisor singleInstance;

    public static native void testVcpu();

    public static native int getPageSize();

    private static native int setHypervisorCallback(long var0, HypervisorCallback var2);

    private static native long nativeInitialize(boolean var0);

    private static native void nativeDestroy(long var0);

    private static native int mem_unmap(long var0, long var2, long var4);

    private static native int mem_map(long var0, long var2, long var4, int var6);

    private static native int mem_protect(long var0, long var2, long var4, int var6);

    private static native int reg_write(long var0, int var2, long var3);

    private static native int reg_set_sp64(long var0, long var2);

    private static native int reg_set_tpidr_el0(long var0, long var2);

    private static native int reg_set_tpidrro_el0(long var0, long var2);

    private static native int reg_set_nzcv(long var0, long var2);

    private static native int reg_set_cpacr_el1(long var0, long var2);

    private static native int reg_set_elr_el1(long var0, long var2);

    private static native byte[] reg_read_vector(long var0, int var2);

    private static native int reg_set_vector(long var0, int var2, byte[] var3);

    private static native int reg_set_spsr_el1(long var0, long var2);

    private static native int mem_write(long var0, long var2, byte[] var4);

    private static native byte[] mem_read(long var0, long var2, int var4);

    private static native long reg_read(long var0, int var2);

    private static native long reg_read_sp64(long var0);

    private static native long reg_read_pc64(long var0);

    private static native long reg_read_nzcv(long var0);

    private static native long reg_read_cpacr_el1(long var0);

    private static native int emu_start(long var0, long var2);

    private static native int emu_stop(long var0);

    public static native long context_alloc();

    private static native void context_save(long var0, long var2);

    private static native void context_restore(long var0, long var2);

    public static native void free(long var0);

    private static native int getBRPs(long var0);

    private static native int getWRPs(long var0);

    public int getBRPs() {
        return Hypervisor.getBRPs(this.nativeHandle);
    }

    public int getWRPs() {
        return Hypervisor.getWRPs(this.nativeHandle);
    }

    private static native void enable_single_step(long var0, boolean var2);

    public void enable_single_step(boolean status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enable_single_step status=" + status));
        }
        Hypervisor.enable_single_step(this.nativeHandle, status);
    }

    public void install_hw_breakpoint(int n, long address) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("install_hw_breakpoint n=" + n + ", address=0x" + Long.toHexString(address)));
        }
        Hypervisor.install_hw_breakpoint(this.nativeHandle, n, address);
    }

    private static native void install_hw_breakpoint(long var0, int var2, long var3);

    public void disable_hw_breakpoint(int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable_hw_breakpoint n=" + n));
        }
        Hypervisor.disable_hw_breakpoint(this.nativeHandle, n);
    }

    private static native void disable_hw_breakpoint(long var0, int var2);

    public void install_watchpoint(int n, long dbgwvr, long dbgwcr) {
        Hypervisor.install_watchpoint(this.nativeHandle, n, dbgwcr, dbgwvr);
        if (log.isDebugEnabled()) {
            log.debug((Object)("install_watchpoint n=" + n + ", dbgwvr=0x" + Long.toHexString(dbgwvr) + ", dbgwcr=0x" + Long.toHexString(dbgwcr)));
        }
    }

    public void disable_watchpoint(int n) {
        Hypervisor.install_watchpoint(this.nativeHandle, n, 0L, 0L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable_watchpoint n=" + n));
        }
    }

    private static native void install_watchpoint(long var0, int var2, long var3, long var5);

    public Hypervisor(boolean is64Bit) {
        if (singleInstance != null) {
            throw new IllegalStateException("Only one hypervisor VM instance per process allowed.");
        }
        this.nativeHandle = Hypervisor.nativeInitialize(is64Bit);
        singleInstance = this;
    }

    public void context_save(long context) {
        Hypervisor.context_save(this.nativeHandle, context);
    }

    public void context_restore(long context) {
        Hypervisor.context_restore(this.nativeHandle, context);
    }

    public void setHypervisorCallback(HypervisorCallback callback) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("setHypervisorCallback callback" + callback));
        }
        if ((ret = Hypervisor.setHypervisorCallback(this.nativeHandle, callback)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void mem_map(long address, long size, int perms) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Hypervisor.mem_map(this.nativeHandle, address, size, perms);
        if (log.isTraceEnabled()) {
            log.trace((Object)("mem_map address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", perms=0b" + Integer.toBinaryString(perms) + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void mem_protect(long address, long size, int perms) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Hypervisor.mem_protect(this.nativeHandle, address, size, perms);
        if (log.isTraceEnabled()) {
            log.trace((Object)("mem_protect address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", perms=0b" + Integer.toBinaryString(perms) + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void mem_unmap(long address, long size) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Hypervisor.mem_unmap(this.nativeHandle, address, size);
        if (log.isTraceEnabled()) {
            log.trace((Object)("mem_unmap address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_write64(int index, long value) {
        int ret;
        if (index < 0 || index > 30) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_write64 index=" + index + ", value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_write(this.nativeHandle, index, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_sp64(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_sp64 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_sp64(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_tpidr_el0(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_tpidr_el0 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_tpidr_el0(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_tpidrro_el0(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_tpidrro_el0 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_tpidrro_el0(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_nzcv(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_nzcv value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_nzcv(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_cpacr_el1(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_cpacr_el1 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_cpacr_el1(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_elr_el1(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_elr_el1 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_elr_el1(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public byte[] reg_read_vector(int index) {
        byte[] ret = Hypervisor.reg_read_vector(this.nativeHandle, index);
        if (ret == null) {
            throw new HypervisorException();
        }
        return ret;
    }

    public void reg_set_vector(int index, byte[] vector) {
        int ret = Hypervisor.reg_set_vector(this.nativeHandle, index, vector);
        if (ret != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void reg_set_spsr_el1(long value) {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_set_spsr_el1 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Hypervisor.reg_set_spsr_el1(this.nativeHandle, value)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void mem_write(long address, byte[] bytes) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Hypervisor.mem_write(this.nativeHandle, address, bytes);
        if (log.isTraceEnabled()) {
            log.trace((Object)("mem_write address=0x" + Long.toHexString(address) + ", size=" + bytes.length + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public byte[] mem_read(long address, int size) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        byte[] ret = Hypervisor.mem_read(this.nativeHandle, address, size);
        if (log.isTraceEnabled()) {
            log.trace((Object)("mem_read address=0x" + Long.toHexString(address) + ", size=" + size + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret == null) {
            throw new HypervisorException();
        }
        return ret;
    }

    public long reg_read64(int index) {
        if (index < 0 || index > 30) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_read64 index=" + index));
        }
        return Hypervisor.reg_read(this.nativeHandle, index);
    }

    public long reg_read_sp64() {
        long sp = Hypervisor.reg_read_sp64(this.nativeHandle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_read_sp64=0x" + Long.toHexString(sp)));
        }
        return sp;
    }

    public long reg_read_pc64() {
        long pc = Hypervisor.reg_read_pc64(this.nativeHandle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_read_pc64=0x" + Long.toHexString(pc)));
        }
        return pc;
    }

    public long reg_read_nzcv() {
        long nzcv = Hypervisor.reg_read_nzcv(this.nativeHandle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_read_nzcv=0x" + Long.toHexString(nzcv)));
        }
        return nzcv;
    }

    public long reg_read_cpacr_el1() {
        long cpacr = Hypervisor.reg_read_cpacr_el1(this.nativeHandle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("reg_read_cpacr_el1=0x" + Long.toHexString(cpacr)));
        }
        return cpacr;
    }

    public void emu_start(long begin) {
        int ret = Hypervisor.emu_start(this.nativeHandle, begin);
        if (ret != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    public void emu_stop() {
        int ret;
        if (log.isTraceEnabled()) {
            log.trace((Object)"emu_stop");
        }
        if ((ret = Hypervisor.emu_stop(this.nativeHandle)) != 0) {
            throw new HypervisorException("ret=" + ret);
        }
    }

    @Override
    public void close() {
        Hypervisor.nativeDestroy(this.nativeHandle);
        singleInstance = null;
    }
}

