/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.hypervisor;

import capstone.api.Disassembler;
import capstone.api.DisassemblerFactory;
import capstone.api.Instruction;
import capstone.api.arm64.OpInfo;
import capstone.api.arm64.OpValue;
import capstone.api.arm64.Operand;
import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.Family;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.DebugHook;
import com.github.unidbg.arm.backend.HypervisorBackend;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.UnHook;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.arm.backend.hypervisor.ExceptionVisitor;
import com.github.unidbg.arm.backend.hypervisor.Hypervisor;
import com.github.unidbg.arm.backend.hypervisor.HypervisorBreakPoint;
import com.github.unidbg.arm.backend.hypervisor.HypervisorException;
import com.github.unidbg.arm.backend.hypervisor.HypervisorWatchpoint;
import com.github.unidbg.debugger.BreakPoint;
import com.github.unidbg.debugger.BreakPointCallback;
import com.github.unidbg.pointer.UnidbgPointer;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HypervisorBackend64
extends HypervisorBackend {
    private static final Log log = LogFactory.getLog(HypervisorBackend64.class);
    private static final int INS_SIZE = 4;
    private Disassembler disassembler;
    private static final long DARWIN_KERNEL_BASE = -549753782272L;
    private static final long _COMM_PAGE64_BASE_ADDRESS = -549753733120L;
    private DebugHook debugCallback;
    private Object debugUserData;
    private final HypervisorBreakPoint[] breakpoints;
    private final Stack<ExceptionVisitor> visitorStack = new Stack();
    private int singleStep;
    private long lastHitPointAddress;
    private final HypervisorWatchpoint[] watchpoints;
    private long lastWatchpointAddress;
    private long lastWatchpointDataAddress;
    private ExclusiveMonitorEscaper exclusiveMonitorEscaper;

    public HypervisorBackend64(Emulator<?> emulator, Hypervisor hypervisor) throws BackendException {
        super(emulator, hypervisor);
        this.breakpoints = new HypervisorBreakPoint[hypervisor.getBRPs()];
        this.watchpoints = new HypervisorWatchpoint[hypervisor.getWRPs()];
    }

    private synchronized Disassembler createDisassembler() {
        if (this.disassembler == null) {
            this.disassembler = DisassemblerFactory.createArm64Disassembler();
            this.disassembler.setDetail(true);
        }
        return this.disassembler;
    }

    @Override
    public void mem_map(long address, long size, int perms) throws BackendException {
        if (address == -549753782272L) {
            throw new BackendException();
        }
        super.mem_map(address, size, perms);
    }

    public void debugger_add(DebugHook callback, long begin, long end, Object user_data) throws BackendException {
        this.debugCallback = callback;
        this.debugUserData = user_data;
    }

    @Override
    public void setSingleStep(int singleStep) {
        this.singleStep = singleStep;
        this.step();
    }

    @Override
    public BreakPoint addBreakPoint(long address, BreakPointCallback callback, boolean thumb) {
        if (thumb) {
            throw new IllegalStateException();
        }
        for (HypervisorBreakPoint breakpoint : this.breakpoints) {
            if (breakpoint == null || breakpoint.address != address) continue;
            return breakpoint;
        }
        for (int i = 0; i < this.breakpoints.length; ++i) {
            if (this.breakpoints[i] != null) continue;
            HypervisorBreakPoint bp = new HypervisorBreakPoint(i, address, callback);
            bp.install(this.hypervisor);
            this.breakpoints[i] = bp;
            return bp;
        }
        throw new UnsupportedOperationException("Max BKPs: " + this.breakpoints.length);
    }

    @Override
    public boolean removeBreakPoint(long address) {
        for (int i = 0; i < this.breakpoints.length; ++i) {
            if (this.breakpoints[i] == null || this.breakpoints[i].address != address) continue;
            this.breakpoints[i] = null;
            this.hypervisor.disable_hw_breakpoint(i);
            return true;
        }
        return false;
    }

    @Override
    public void handleUnknownException(int ec, long esr, long far, long virtualAddress) {
        switch (ec) {
            case 36: {
                boolean sf;
                boolean isv = (esr & 0x1000000L) != 0L;
                boolean isWrite = (esr >> 6 & 1L) != 0L;
                int sas = (int)(esr >> 22 & 3L);
                int accessSize = isv ? 1 << sas : 0;
                int srt = (int)(esr >> 16 & 0x1FL);
                boolean bl = sf = (esr >> 15 & 1L) != 0L;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("handleDataAbort srt=" + srt + ", sf=" + sf + ", accessSize=" + accessSize));
                }
                if (this.eventMemHookNotifier == null) break;
                this.eventMemHookNotifier.notifyDataAbort(isWrite, accessSize, virtualAddress);
                break;
            }
            case 32: {
                if (this.eventMemHookNotifier == null) break;
                this.eventMemHookNotifier.notifyInsnAbort(virtualAddress);
                break;
            }
            default: {
                log.warn((Object)("handleUnknownException ec=0x" + Integer.toHexString(ec) + ", virtualAddress=0x" + Long.toHexString(virtualAddress) + ", esr=0x" + Long.toHexString(esr) + ", far=0x" + Long.toHexString(far)));
            }
        }
    }

    @Override
    public boolean handleException(long esr, long far, long elr, long cpsr) {
        int ec = (int)(esr >> 26 & 0x3FL);
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleException syndrome=0x" + Long.toHexString(esr) + ", far=0x" + Long.toHexString(far) + ", elr=0x" + Long.toHexString(elr) + ", ec=0x" + Integer.toHexString(ec) + ", cpsr=0x" + Long.toHexString(cpsr)));
        }
        if (this.lastHitPointAddress != elr && (ec == 50 || ec == 48)) {
            while (!this.visitorStack.isEmpty()) {
                if (!this.visitorStack.pop().onException(this.hypervisor, ec, elr)) continue;
                return true;
            }
        }
        switch (ec) {
            case 21: {
                int swi = (int)(esr & 0xFFFFL);
                this.callSVC(elr, swi);
                return true;
            }
            case 60: {
                int bkpt = (int)(esr & 0xFFFFL);
                this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, bkpt);
                return true;
            }
            case 50: {
                this.onSoftwareStep(esr, elr, cpsr);
                return true;
            }
            case 48: {
                this.lastHitPointAddress = elr;
                this.onBreakpoint(esr, elr);
                for (int i = 0; i < this.breakpoints.length; ++i) {
                    HypervisorBreakPoint bp = this.breakpoints[i];
                    if (bp == null || bp.address != elr) continue;
                    this.hypervisor.disable_hw_breakpoint(i);
                    this.visitorStack.push(ExceptionVisitor.breakRestorerVisitor(bp));
                    this.step();
                    break;
                }
                return true;
            }
            case 52: {
                this.lastHitPointAddress = elr;
                this.onWatchpoint(esr, far, elr);
                return true;
            }
            case 36: {
                boolean isv = (esr & 0x1000000L) != 0L;
                boolean isWrite = (esr >> 6 & 1L) != 0L;
                boolean s1ptw = (esr >> 7 & 1L) != 0L;
                int sas = (int)(esr >> 22 & 3L);
                int len = 1 << sas;
                int srt = (int)(esr >> 16 & 0x1FL);
                int dfsc = (int)(esr & 0x3FL);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("handle EC_DATAABORT isv=" + isv + ", isWrite=" + isWrite + ", s1ptw=" + s1ptw + ", len=" + len + ", srt=" + srt + ", dfsc=0x" + Integer.toHexString(dfsc) + ", vaddr=0x" + Long.toHexString(far)));
                }
                if (dfsc == 0 && this.emulator.getFamily() == Family.iOS) {
                    int accessSize = isv ? 1 << sas : 0;
                    return this.handleCommRead(far, elr, accessSize);
                }
                throw new UnsupportedOperationException("handleException ec=0x" + Integer.toHexString(ec) + ", dfsc=0x" + Integer.toHexString(dfsc));
            }
            case 24: {
                boolean isRead = (esr & 1L) != 0L;
                int CRm = (int)(esr >>> 1 & 0xFL);
                int Rt = (int)(esr >>> 5 & 0x1FL);
                int CRn = (int)(esr >>> 10 & 0xFL);
                int Op1 = (int)(esr >>> 14) & 7;
                int Op2 = (int)(esr >>> 17) & 7;
                int Op0 = (int)(esr >>> 20) & 3;
                if (isRead) {
                    if (CRm == 0 && CRn == 14 && Op1 == 3 && Op2 == 1 && Op0 == 3) {
                        this.hypervisor.reg_write64(Rt, 0L);
                        this.hypervisor.reg_set_elr_el1(elr + 4L);
                        return true;
                    }
                    if (CRm == 0 && CRn == 14 && Op1 == 3 && Op2 == 2 && Op0 == 3) {
                        this.hypervisor.reg_write64(Rt, 0L);
                        this.hypervisor.reg_set_elr_el1(elr + 4L);
                        return true;
                    }
                }
                throw new UnsupportedOperationException("EC_SYSTEMREGISTERTRAP isRead=" + isRead + ", CRm=" + CRm + ", CRn=" + CRn + ", Op1=" + Op1 + ", Op2=" + Op2 + ", Op0=" + Op0);
            }
        }
        log.warn((Object)("handleException ec=0x" + Integer.toHexString(ec)));
        throw new UnsupportedOperationException("handleException ec=0x" + Integer.toHexString(ec));
    }

    private void step() {
        if (this.singleStep < 0) {
            this.singleStep = 0;
        }
        this.hypervisor.enable_single_step(true);
    }

    public void hook_add_new(ReadHook callback, long begin, long end, Object user_data) throws BackendException {
        for (int i = 0; i < this.watchpoints.length; ++i) {
            if (this.watchpoints[i] != null) continue;
            HypervisorWatchpoint wp = new HypervisorWatchpoint(callback, begin, end, user_data, i, false);
            wp.install(this.hypervisor);
            this.watchpoints[i] = wp;
            return;
        }
        throw new UnsupportedOperationException("Max WRPs: " + this.watchpoints.length);
    }

    public void hook_add_new(WriteHook callback, long begin, long end, Object user_data) throws BackendException {
        for (int i = 0; i < this.watchpoints.length; ++i) {
            if (this.watchpoints[i] != null) continue;
            HypervisorWatchpoint wp = new HypervisorWatchpoint(callback, begin, end, user_data, i, true);
            wp.install(this.hypervisor);
            this.watchpoints[i] = wp;
            return;
        }
        throw new UnsupportedOperationException("Max WRPs: " + this.watchpoints.length);
    }

    private void onWatchpoint(long esr, long address, long elr) {
        boolean wptv;
        boolean repeatWatchpoint;
        boolean bl = repeatWatchpoint = this.lastWatchpointAddress == elr && this.lastWatchpointDataAddress == address;
        if (!repeatWatchpoint) {
            this.lastWatchpointAddress = elr;
            this.lastWatchpointDataAddress = address;
        }
        boolean write = (esr >> 6 & 1L) == 1L;
        int status = (int)(esr & 0x3FL);
        boolean cm = (esr >> 8 & 1L) == 1L;
        int wpt = (int)(esr >> 18 & 0x3FL);
        boolean bl2 = wptv = (esr >> 17 & 1L) == 1L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("onWatchpoint write=" + write + ", address=0x" + Long.toHexString(address) + ", cm=" + cm + ", wpt=" + wpt + ", wptv=" + wptv + ", status=0x" + Integer.toHexString(status)));
        }
        HypervisorWatchpoint hitWp = null;
        for (int n = 0; n < this.watchpoints.length; ++n) {
            HypervisorWatchpoint watchpoint = this.watchpoints[n];
            if (watchpoint == null || !watchpoint.contains(address, write)) continue;
            hitWp = watchpoint;
            if (repeatWatchpoint) break;
            UnidbgPointer pc = UnidbgPointer.pointer((Emulator)this.emulator, (long)elr);
            assert (pc != null);
            byte[] code = pc.getByteArray(0L, 4);
            if (!watchpoint.onHit(this, address, write, this.createDisassembler(), code, elr)) continue;
            this.hypervisor.disable_watchpoint(n);
            this.visitorStack.push(ExceptionVisitor.breakRestorerVisitor(watchpoint));
            this.step();
            return;
        }
        if (hitWp == null) {
            this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, status);
        } else if (repeatWatchpoint) {
            if (this.exclusiveMonitorEscaper != null) {
                this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, status);
            } else {
                this.exclusiveMonitorEscaper = new ExclusiveMonitorEscaper(new WatchpointExclusiveMonitorEscaper(hitWp));
            }
        } else {
            this.hypervisor.disable_watchpoint(hitWp.n);
            this.visitorStack.push(ExceptionVisitor.breakRestorerVisitor(hitWp));
            this.step();
        }
    }

    private void onBreakpoint(long esr, long elr) {
        if (this.debugCallback != null) {
            this.debugCallback.onBreak((Backend)this, elr, 4, this.debugUserData);
        } else {
            int status = (int)(esr & 0x3FL);
            this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, status);
        }
    }

    public void hook_add_new(CodeHook callback, long begin, long end, Object user_data) throws BackendException {
        if (this.exclusiveMonitorEscaper != null) {
            throw new IllegalStateException();
        }
        CodeHookNotifier codeHookNotifier = new CodeHookNotifier(callback, begin, end, user_data);
        this.exclusiveMonitorEscaper = new ExclusiveMonitorEscaper(codeHookNotifier);
        callback.onAttach((UnHook)codeHookNotifier);
    }

    private void onSoftwareStep(long esr, long address, long spsr) {
        if (this.exclusiveMonitorEscaper != null) {
            this.exclusiveMonitorEscaper.onSoftwareStep(spsr, address);
            return;
        }
        if (this.singleStep <= 0) {
            this.hypervisor.enable_single_step(false);
            return;
        }
        if (--this.singleStep == 0) {
            if (this.debugCallback != null) {
                this.debugCallback.onBreak((Backend)this, address, 4, this.debugUserData);
            } else {
                int status = (int)(esr & 0x3FL);
                this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, status);
            }
        } else {
            this.hypervisor.reg_set_spsr_el1(spsr | 0x200000L);
        }
    }

    private boolean handleCommRead(long vaddr, long elr, int accessSize) {
        OpInfo opInfo;
        UnidbgPointer pointer = UnidbgPointer.pointer((Emulator)this.emulator, (long)vaddr);
        assert (pointer != null);
        UnidbgPointer pc = UnidbgPointer.pointer((Emulator)this.emulator, (long)elr);
        assert (pc != null);
        byte[] code = pc.getByteArray(0L, 4);
        Instruction insn = this.createDisassembler().disasm(code, elr, 1L)[0];
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleCommRead vaddr=0x" + Long.toHexString(vaddr) + ", elr=0x" + Long.toHexString(elr) + ", asm=" + insn));
        }
        if ((opInfo = (OpInfo)insn.getOperands()).isUpdateFlags() || opInfo.isWriteBack() || !insn.getMnemonic().startsWith("ldr") || vaddr < -549753733120L) {
            if (this.eventMemHookNotifier != null) {
                this.eventMemHookNotifier.notifyDataAbort(false, accessSize, vaddr);
            }
            return false;
        }
        Operand[] op = opInfo.getOperands();
        int offset = (int)(vaddr - -549753733120L);
        switch (offset) {
            case 56: 
            case 64: 
            case 88: {
                Operand operand = op[0];
                OpValue value = operand.getValue();
                this.reg_write(insn.mapToUnicornReg(value.getReg()), 0L);
                this.hypervisor.reg_set_elr_el1(elr + 4L);
                return true;
            }
            case 72: 
            case 76: 
            case 80: 
            case 96: 
            case 100: 
            case 144: {
                Operand operand = op[0];
                OpValue value = operand.getValue();
                this.reg_write(insn.mapToUnicornReg(value.getReg()), 0);
                this.hypervisor.reg_set_elr_el1(elr + 4L);
                return true;
            }
            case 34: 
            case 52: 
            case 53: 
            case 54: {
                Operand operand = op[0];
                OpValue value = operand.getValue();
                this.reg_write(insn.mapToUnicornReg(value.getReg()), 1);
                this.hypervisor.reg_set_elr_el1(elr + 4L);
                return true;
            }
        }
        throw new UnsupportedOperationException("vaddr=0x" + Long.toHexString(vaddr) + ", offset=0x" + Long.toHexString(offset));
    }

    public void enableVFP() {
        long value = this.reg_read(261).longValue();
        this.reg_write(261, value |= 0x300000L);
    }

    public void switchUserMode() {
    }

    public void reg_write(int regId, Number value) throws BackendException {
        try {
            switch (regId) {
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.hypervisor.reg_write64(regId - 199, value.longValue());
                    break;
                }
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: {
                    this.hypervisor.reg_write64(regId - 168, value.longValue());
                    break;
                }
                case 4: {
                    this.hypervisor.reg_set_sp64(value.longValue());
                    break;
                }
                case 1: {
                    this.hypervisor.reg_write64(29, value.longValue());
                    break;
                }
                case 2: {
                    this.hypervisor.reg_write64(30, value.longValue());
                    break;
                }
                case 262: {
                    this.hypervisor.reg_set_tpidr_el0(value.longValue());
                    break;
                }
                case 263: {
                    this.hypervisor.reg_set_tpidrro_el0(value.longValue());
                    break;
                }
                case 3: {
                    this.hypervisor.reg_set_nzcv(value.longValue());
                    break;
                }
                case 261: {
                    this.hypervisor.reg_set_cpacr_el1(value.longValue());
                    break;
                }
                default: {
                    throw new HypervisorException("regId=" + regId);
                }
            }
        }
        catch (HypervisorException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public Number reg_read(int regId) throws BackendException {
        try {
            switch (regId) {
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 216: 
                case 217: 
                case 218: 
                case 219: 
                case 220: 
                case 221: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    return this.hypervisor.reg_read64(regId - 199);
                }
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: {
                    return (int)(this.hypervisor.reg_read64(regId - 168) & 0xFFFFFFFFL);
                }
                case 4: {
                    return this.hypervisor.reg_read_sp64();
                }
                case 1: {
                    return this.hypervisor.reg_read64(29);
                }
                case 2: {
                    return this.hypervisor.reg_read64(30);
                }
                case 260: {
                    return this.hypervisor.reg_read_pc64();
                }
                case 3: {
                    return this.hypervisor.reg_read_nzcv();
                }
                case 261: {
                    return this.hypervisor.reg_read_cpacr_el1();
                }
            }
            throw new HypervisorException("regId=" + regId);
        }
        catch (HypervisorException e) {
            throw new BackendException((Throwable)e);
        }
    }

    protected byte[] addSoftBreakPoint(long address, int svcNumber, boolean thumb) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm64, KeystoneMode.LittleEndian);){
            KeystoneEncoded encoded = keystone.assemble("brk #" + svcNumber);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }

    @Override
    public synchronized void destroy() throws BackendException {
        super.destroy();
        IOUtils.close((Closeable)this.disassembler);
        this.disassembler = null;
    }

    public long context_alloc() {
        return Hypervisor.context_alloc();
    }

    public void context_save(long context) {
        this.hypervisor.context_save(context);
    }

    public void context_restore(long context) {
        this.hypervisor.context_restore(context);
    }

    public void context_free(long context) {
        Hypervisor.free(context);
    }

    private class CodeHookNotifier
    implements UnHook,
    ExclusiveMonitorCallback {
        private final CodeHook callback;
        private final long begin;
        private final long end;
        private final Object user;

        public CodeHookNotifier(CodeHook callback, long begin, long end, Object user) {
            this.callback = callback;
            this.begin = begin;
            this.end = end;
            this.user = user;
        }

        @Override
        public void onEscapeSuccess() {
            HypervisorBackend64.this.step();
        }

        @Override
        public void notifyCallback(long address) {
            if (this.begin >= this.end || address >= this.begin && address < this.end) {
                this.callback.hook((Backend)HypervisorBackend64.this, address, 4, this.user);
            }
        }

        public void unhook() {
            HypervisorBackend64.this.exclusiveMonitorEscaper = null;
        }
    }

    private class ExclusiveMonitorEscaper {
        private final ExclusiveMonitorCallback callback;
        private long loadExclusiveAddress;
        private int loadExclusiveCount;
        private final List<Long> exclusiveRegionAddressList = new ArrayList<Long>();

        ExclusiveMonitorEscaper(ExclusiveMonitorCallback callback) {
            this.callback = callback;
            HypervisorBackend64.this.step();
        }

        private void resetRegionInfo() {
            this.loadExclusiveAddress = 0L;
            this.loadExclusiveCount = 0;
            this.exclusiveRegionAddressList.clear();
        }

        private boolean isLoadExclusiveCode(int asm) {
            if ((asm & 0xBFFFFC00) == -2006975488) {
                return true;
            }
            if ((asm & 0xFFFFFC00) == 1214249984) {
                return true;
            }
            if ((asm & 0xFFFFFC00) == 1214217216) {
                return true;
            }
            return (asm & 0xBFFFFC00) == -2007008256;
        }

        final void onSoftwareStep(long spsr, long address) {
            UnidbgPointer pointer = UnidbgPointer.pointer((Emulator)HypervisorBackend64.this.emulator, (long)address);
            assert (pointer != null);
            int asm = pointer.getInt(0L);
            if (this.isLoadExclusiveCode(asm)) {
                this.loadExclusiveCount = this.loadExclusiveAddress == address ? ++this.loadExclusiveCount : 0;
                this.loadExclusiveAddress = address;
            } else if (this.loadExclusiveAddress == 0L) {
                this.resetRegionInfo();
            }
            if (this.loadExclusiveCount >= 2 && !this.exclusiveRegionAddressList.contains(address)) {
                this.exclusiveRegionAddressList.add(address);
            }
            if (this.loadExclusiveCount >= 4 && address == this.loadExclusiveAddress) {
                long foundAddress = 0L;
                StringBuilder builder = new StringBuilder();
                for (long pc : this.exclusiveRegionAddressList) {
                    UnidbgPointer ptr = UnidbgPointer.pointer((Emulator)HypervisorBackend64.this.emulator, (long)pc);
                    assert (ptr != null);
                    byte[] code = ptr.getByteArray(0L, 4);
                    Instruction instruction = HypervisorBackend64.this.createDisassembler().disasm(code, pc, 1L)[0];
                    switch (instruction.getMnemonic()) {
                        case "stxr": 
                        case "stlxr": 
                        case "stxrh": 
                        case "stlxrh": {
                            foundAddress = pc;
                        }
                    }
                    builder.append(String.format("0x%x: %s%n", instruction.getAddress(), instruction));
                }
                if (foundAddress == 0L) {
                    log.info((Object)("CodeHookNotifier.onSoftwareStep: \n" + builder));
                } else {
                    this.resetRegionInfo();
                    long breakAddress = foundAddress + 4L;
                    for (int i = 0; i < HypervisorBackend64.this.breakpoints.length; ++i) {
                        if (HypervisorBackend64.this.breakpoints[i] != null) continue;
                        final int n = i;
                        HypervisorBackend64.this.visitorStack.push(new ExceptionVisitor(){

                            @Override
                            public boolean onException(Hypervisor hypervisor, int ec, long address) {
                                if (ec == 48) {
                                    ExclusiveMonitorEscaper.this.callback.notifyCallback(address);
                                }
                                ((HypervisorBackend64)HypervisorBackend64.this).breakpoints[n] = null;
                                hypervisor.disable_hw_breakpoint(n);
                                ExclusiveMonitorEscaper.this.callback.onEscapeSuccess();
                                HypervisorBackend64.this.step();
                                return true;
                            }
                        });
                        this.callback.notifyCallback(address);
                        HypervisorBreakPoint bp = new HypervisorBreakPoint(n, breakAddress, null);
                        bp.install(HypervisorBackend64.this.hypervisor);
                        ((HypervisorBackend64)HypervisorBackend64.this).breakpoints[n] = bp;
                        HypervisorBackend64.this.hypervisor.enable_single_step(false);
                        HypervisorBackend64.this.hypervisor.reg_set_spsr_el1(spsr | 0x200000L);
                        return;
                    }
                    log.warn((Object)("No more BKPs: " + HypervisorBackend64.this.breakpoints.length));
                }
            }
            this.callback.notifyCallback(address);
            HypervisorBackend64.this.hypervisor.reg_set_spsr_el1(spsr | 0x200000L);
        }
    }

    private static interface ExclusiveMonitorCallback {
        public void notifyCallback(long var1);

        public void onEscapeSuccess();
    }

    private class WatchpointExclusiveMonitorEscaper
    implements ExclusiveMonitorCallback {
        private final HypervisorWatchpoint wp;

        WatchpointExclusiveMonitorEscaper(HypervisorWatchpoint wp) {
            this.wp = wp;
            HypervisorBackend64.this.hypervisor.disable_watchpoint(wp.n);
        }

        @Override
        public void notifyCallback(long address) {
        }

        @Override
        public void onEscapeSuccess() {
            this.wp.install(HypervisorBackend64.this.hypervisor);
            HypervisorBackend64.this.exclusiveMonitorEscaper = null;
        }
    }
}

