/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend;

import com.alibaba.fastjson.util.IOUtils;
import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.BlockHook;
import com.github.unidbg.arm.backend.CodeHook;
import com.github.unidbg.arm.backend.EventMemHook;
import com.github.unidbg.arm.backend.FastBackend;
import com.github.unidbg.arm.backend.InterruptHook;
import com.github.unidbg.arm.backend.InterruptHookNotifier;
import com.github.unidbg.arm.backend.ReadHook;
import com.github.unidbg.arm.backend.UserMemoryRegion;
import com.github.unidbg.arm.backend.WriteHook;
import com.github.unidbg.arm.backend.kvm.Kvm;
import com.github.unidbg.arm.backend.kvm.KvmCallback;
import com.github.unidbg.arm.backend.kvm.KvmException;
import java.io.Closeable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KvmBackend
extends FastBackend
implements Backend,
KvmCallback {
    private static final Log log = LogFactory.getLog(KvmBackend.class);
    protected static final long REG_VBAR_EL1 = 0xF0000000L;
    protected final Kvm kvm;
    private final int pageSize;
    private int slotIndex;
    private final UserMemoryRegion[] slots;
    protected final Map<Long, UserMemoryRegion> memoryRegionMap;
    protected InterruptHookNotifier interruptHookNotifier;
    protected long until;

    protected KvmBackend(Emulator<?> emulator, Kvm kvm) throws BackendException {
        super(emulator);
        this.kvm = kvm;
        this.pageSize = Kvm.getPageSize();
        int maxSlots = Kvm.getMaxSlots();
        if (log.isDebugEnabled()) {
            log.debug((Object)("init kvm backend kvm=" + kvm + ", maxSlots=0x" + Integer.toHexString(maxSlots) + ", pageSize=0x" + Integer.toHexString(this.pageSize)));
        }
        this.slots = new UserMemoryRegion[maxSlots];
        this.memoryRegionMap = new TreeMap<Long, UserMemoryRegion>();
        try {
            this.kvm.setKvmCallback(this);
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    private int allocateSlot() {
        for (int i = this.slotIndex; i < this.slots.length; ++i) {
            if (this.slots[i] != null) continue;
            return i;
        }
        throw new BackendException("Allocate slot failed: slotIndex=" + this.slotIndex + ", maxSlots=" + this.slots.length);
    }

    public void mem_map(long address, long size, int perms) throws BackendException {
        if ((address & (long)(this.pageSize - 1)) != 0L) {
            throw new IllegalArgumentException("mem_map address=0x" + Long.toHexString(address));
        }
        if ((size & (long)(this.pageSize - 1)) != 0L) {
            throw new IllegalArgumentException("mem_map size=0x" + Long.toHexString(size));
        }
        int slot = this.allocateSlot();
        long userspace_addr = this.kvm.set_user_memory_region(slot, address, size, 0L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mem_map slot=" + slot + ", address=0x" + Long.toHexString(address) + ", size=0x" + Long.toHexString(size) + ", userspace_addr=0x" + Long.toHexString(userspace_addr)));
        }
        UserMemoryRegion region = new UserMemoryRegion(slot, address, size, userspace_addr);
        this.memoryRegionMap.put(region.guest_phys_addr, region);
        this.slots[slot++] = region;
        this.slotIndex = slot;
    }

    private void mem_unmap_page(long address, UserMemoryRegion region) {
        if ((long)this.pageSize == region.memory_size) {
            if (address != region.guest_phys_addr) {
                throw new IllegalStateException("address=0x" + Long.toHexString(address) + ", guest_phys_addr=0x" + Long.toHexString(region.guest_phys_addr));
            }
            this.kvm.remove_user_memory_region(region.slot, region.guest_phys_addr, region.memory_size, region.userspace_addr, 0L);
            this.slotIndex = region.slot;
            this.slots[this.slotIndex] = null;
            this.memoryRegionMap.remove(region.guest_phys_addr);
            return;
        }
        if (address == region.guest_phys_addr && (long)this.pageSize < region.memory_size) {
            this.kvm.remove_user_memory_region(region.slot, region.guest_phys_addr, this.pageSize, region.userspace_addr, 0L);
            this.memoryRegionMap.remove(region.guest_phys_addr);
            long userspace_addr = this.kvm.set_user_memory_region(region.slot, region.guest_phys_addr + (long)this.pageSize, region.memory_size - (long)this.pageSize, region.userspace_addr + (long)this.pageSize);
            UserMemoryRegion newRegion = new UserMemoryRegion(region.slot, region.guest_phys_addr + (long)this.pageSize, region.memory_size - (long)this.pageSize, userspace_addr);
            this.memoryRegionMap.put(newRegion.guest_phys_addr, newRegion);
            this.slots[newRegion.slot] = newRegion;
            return;
        }
        if (address > region.guest_phys_addr && address + (long)this.pageSize == region.guest_phys_addr + region.memory_size) {
            long off = address - region.guest_phys_addr;
            this.kvm.remove_user_memory_region(region.slot, region.guest_phys_addr, this.pageSize, region.userspace_addr, off);
            this.memoryRegionMap.remove(region.guest_phys_addr);
            long userspace_addr = this.kvm.set_user_memory_region(region.slot, region.guest_phys_addr, region.memory_size - (long)this.pageSize, region.userspace_addr);
            UserMemoryRegion newRegion = new UserMemoryRegion(region.slot, region.guest_phys_addr, region.memory_size - (long)this.pageSize, userspace_addr);
            this.memoryRegionMap.put(newRegion.guest_phys_addr, newRegion);
            this.slots[newRegion.slot] = newRegion;
            return;
        }
        if (address > region.guest_phys_addr && address + (long)this.pageSize < region.guest_phys_addr + region.memory_size) {
            this.kvm.remove_user_memory_region(region.slot, region.guest_phys_addr, 0L, region.userspace_addr, 0L);
            this.memoryRegionMap.remove(region.guest_phys_addr);
            long first_memory_size = address - region.guest_phys_addr;
            long second_memory_size = region.memory_size - first_memory_size;
            long first_guest_phys_addr = region.guest_phys_addr;
            long first_userspace_addr = this.kvm.set_user_memory_region(region.slot, first_guest_phys_addr, first_memory_size, region.userspace_addr);
            UserMemoryRegion first = new UserMemoryRegion(region.slot, first_guest_phys_addr, first_memory_size, first_userspace_addr);
            this.memoryRegionMap.put(first.guest_phys_addr, first);
            this.slots[first.slot] = first;
            int slot = this.allocateSlot();
            long second_userspace_addr = this.kvm.set_user_memory_region(slot, address, second_memory_size, first_userspace_addr + first_memory_size);
            UserMemoryRegion second = new UserMemoryRegion(slot, address, second_memory_size, second_userspace_addr);
            this.memoryRegionMap.put(second.guest_phys_addr, second);
            this.slots[slot++] = second;
            this.slotIndex = slot;
            this.mem_unmap(address, this.pageSize);
            return;
        }
        throw new UnsupportedOperationException("address=0x" + Long.toHexString(address));
    }

    public final void mem_unmap(long address, long size) throws BackendException {
        if ((address & (long)(this.pageSize - 1)) != 0L) {
            throw new IllegalArgumentException("mem_unmap address=0x" + Long.toHexString(address));
        }
        if ((size & (long)(this.pageSize - 1)) != 0L) {
            throw new IllegalArgumentException("mem_unmap size=0x" + Long.toHexString(size));
        }
        for (long i = address; i < address + size; i += (long)this.pageSize) {
            UserMemoryRegion userMemoryRegion = null;
            for (UserMemoryRegion region : this.memoryRegionMap.values()) {
                long max;
                long min = Math.max(i, region.guest_phys_addr);
                if (min >= (max = Math.min(i + (long)this.pageSize, region.guest_phys_addr + region.memory_size))) continue;
                userMemoryRegion = region;
                break;
            }
            if (userMemoryRegion == null) {
                throw new IllegalStateException("find userMemoryRegion failed: i=0x" + Long.toHexString(i));
            }
            this.mem_unmap_page(i, userMemoryRegion);
        }
    }

    public final void mem_protect(long address, long size, int perms) throws BackendException {
    }

    public final void mem_write(long address, byte[] bytes) throws BackendException {
        try {
            this.kvm.mem_write(address, bytes);
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public final byte[] mem_read(long address, long size) throws BackendException {
        try {
            return this.kvm.mem_read(address, (int)size);
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    protected final void callSVC(long pc, int swi) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("callSVC pc=0x" + Long.toHexString(pc) + ", until=0x" + Long.toHexString(this.until) + ", swi=" + swi));
        }
        if (pc == this.until) {
            this.emu_stop();
            return;
        }
        this.interruptHookNotifier.notifyCallSVC((Backend)this, 2, swi);
    }

    public final void hook_add_new(InterruptHook callback, Object user_data) throws BackendException {
        if (this.interruptHookNotifier != null) {
            throw new IllegalStateException();
        }
        this.interruptHookNotifier = new InterruptHookNotifier(callback, user_data);
    }

    public synchronized void emu_start(long begin, long until, long timeout, long count) throws BackendException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("emu_start begin=0x" + Long.toHexString(begin) + ", until=0x" + Long.toHexString(until) + ", timeout=" + timeout + ", count=" + count));
        }
        this.until = until + 4L;
        try {
            this.kvm.emu_start(begin);
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public final void emu_stop() throws BackendException {
        try {
            this.kvm.emu_stop();
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void destroy() throws BackendException {
        IOUtils.close((Closeable)this.kvm);
    }

    public void hook_add_new(EventMemHook callback, int type, Object user_data) throws BackendException {
    }

    public void hook_add_new(ReadHook callback, long begin, long end, Object user_data) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void hook_add_new(WriteHook callback, long begin, long end, Object user_data) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void hook_add_new(CodeHook callback, long begin, long end, Object user_data) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void hook_add_new(BlockHook callback, long begin, long end, Object user_data) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void context_restore(long context) {
        throw new UnsupportedOperationException();
    }

    public void context_free(long context) {
        throw new UnsupportedOperationException();
    }

    public void context_save(long context) {
        throw new UnsupportedOperationException();
    }

    public long context_alloc() {
        throw new UnsupportedOperationException();
    }
}

