/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.kvm;

import com.github.unidbg.arm.backend.kvm.KvmCallback;
import com.github.unidbg.arm.backend.kvm.KvmException;
import java.io.Closeable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Kvm
implements Closeable {
    private static final Log log = LogFactory.getLog(Kvm.class);
    private final long nativeHandle;
    private static Kvm singleInstance;

    private static native int setKvmCallback(long var0, KvmCallback var2);

    public static native int getMaxSlots();

    public static native int getPageSize();

    private static native long nativeInitialize(boolean var0);

    private static native void nativeDestroy(long var0);

    private static native long set_user_memory_region(long var0, int var2, long var3, long var5, long var7);

    private static native int remove_user_memory_region(long var0, int var2, long var3, long var5, long var7, long var9);

    private static native long reg_read_cpacr_el1(long var0);

    private static native int reg_set_cpacr_el1(long var0, long var2);

    private static native int reg_set_fpexc(long var0, long var2);

    private static native int reg_set_sp64(long var0, long var2);

    private static native long reg_read_sp64(long var0);

    private static native int reg_set_tpidr_el0(long var0, long var2);

    private static native int reg_set_tpidrro_el0(long var0, long var2);

    private static native int reg_set_nzcv(long var0, long var2);

    private static native int reg_set_elr_el1(long var0, long var2);

    private static native long reg_read_pc64(long var0);

    private static native long reg_read_nzcv(long var0);

    private static native int mem_write(long var0, long var2, byte[] var4);

    private static native byte[] mem_read(long var0, long var2, int var4);

    private static native int reg_write(long var0, int var2, long var3);

    private static native long reg_read(long var0, int var2);

    private static native int emu_start(long var0, long var2);

    private static native int emu_stop(long var0);

    public Kvm(boolean is64Bit) {
        if (singleInstance != null) {
            throw new IllegalStateException("Only one kvm VM instance per process allowed.");
        }
        this.nativeHandle = Kvm.nativeInitialize(is64Bit);
        singleInstance = this;
    }

    public void setKvmCallback(KvmCallback callback) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setKvmCallback callback" + callback));
        }
        if ((ret = Kvm.setKvmCallback(this.nativeHandle, callback)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public long set_user_memory_region(int slot, long guest_phys_addr, long memory_size, long old_addr) {
        long userspace_addr = Kvm.set_user_memory_region(this.nativeHandle, slot, guest_phys_addr, memory_size, old_addr);
        if (userspace_addr == 0L) {
            throw new KvmException("set_user_memory_region failed: slot=" + slot + ", guest_phys_addr=0x" + Long.toHexString(guest_phys_addr) + ", memory_size=0x" + Long.toHexString(memory_size) + ", old_addr=0x" + Long.toHexString(old_addr));
        }
        return userspace_addr;
    }

    public void remove_user_memory_region(int slot, long guest_phys_addr, long memory_size, long userspace_addr, long vaddr_off) {
        int ret = Kvm.remove_user_memory_region(this.nativeHandle, slot, guest_phys_addr, memory_size, userspace_addr, vaddr_off);
        if (ret != 0) {
            throw new KvmException("remove_user_memory_region failed: slot=" + slot + ", guest_phys_addr=0x" + Long.toHexString(guest_phys_addr) + ", memory_size=0x" + Long.toHexString(memory_size) + ", userspace_addr=0x" + Long.toHexString(userspace_addr) + ", vaddr_off=0x" + Long.toHexString(vaddr_off));
        }
    }

    public long reg_read_cpacr_el1() {
        long cpacr = Kvm.reg_read_cpacr_el1(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_read_cpacr_el1=0x" + Long.toHexString(cpacr)));
        }
        return cpacr;
    }

    public void reg_set_cpacr_el1(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_cpacr_el1 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_cpacr_el1(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void reg_set_sp64(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_sp64 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_sp64(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void reg_set_fpexc(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_fpexc value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_fpexc(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void reg_set_elr_el1(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_elr_el1 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_elr_el1(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public long reg_read_sp64() {
        long sp = Kvm.reg_read_sp64(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_read_sp64=0x" + Long.toHexString(sp)));
        }
        return sp;
    }

    public long reg_read_pc64() {
        long pc = Kvm.reg_read_pc64(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_read_pc64=0x" + Long.toHexString(pc)));
        }
        return pc;
    }

    public long reg_read_nzcv() {
        long nzcv = Kvm.reg_read_nzcv(this.nativeHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_read_nzcv=0x" + Long.toHexString(nzcv)));
        }
        return nzcv;
    }

    public void mem_write(long address, byte[] bytes) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        int ret = Kvm.mem_write(this.nativeHandle, address, bytes);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mem_write address=0x" + Long.toHexString(address) + ", size=" + bytes.length + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public byte[] mem_read(long address, int size) {
        long start = log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        byte[] ret = Kvm.mem_read(this.nativeHandle, address, size);
        if (log.isDebugEnabled()) {
            log.debug((Object)("mem_read address=0x" + Long.toHexString(address) + ", size=" + size + ", offset=" + (System.currentTimeMillis() - start) + "ms"));
        }
        if (ret == null) {
            throw new KvmException();
        }
        return ret;
    }

    public void reg_set_tpidr_el0(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_tpidr_el0 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_tpidr_el0(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void reg_set_tpidrro_el0(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_tpidrro_el0 value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_tpidrro_el0(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void reg_set_nzcv(long value) {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_set_nzcv value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_set_nzcv(this.nativeHandle, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void reg_write64(int index, long value) {
        int ret;
        if (index < 0 || index > 30) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_write64 index=" + index + ", value=0x" + Long.toHexString(value)));
        }
        if ((ret = Kvm.reg_write(this.nativeHandle, index, value)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public long reg_read64(int index) {
        if (index < 0 || index > 30) {
            throw new IllegalArgumentException("index=" + index);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("reg_read64 index=" + index));
        }
        return Kvm.reg_read(this.nativeHandle, index);
    }

    public void emu_start(long begin) {
        int ret = Kvm.emu_start(this.nativeHandle, begin);
        if (ret != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    public void emu_stop() {
        int ret;
        if (log.isDebugEnabled()) {
            log.debug((Object)"emu_stop");
        }
        if ((ret = Kvm.emu_stop(this.nativeHandle)) != 0) {
            throw new KvmException("ret=" + ret);
        }
    }

    @Override
    public void close() {
        Kvm.nativeDestroy(this.nativeHandle);
        singleInstance = null;
    }
}

