/*
 * Decompiled with CFR 0.152.
 */
package com.github.unidbg.arm.backend.kvm;

import com.github.unidbg.Emulator;
import com.github.unidbg.arm.backend.Backend;
import com.github.unidbg.arm.backend.BackendException;
import com.github.unidbg.arm.backend.DebugHook;
import com.github.unidbg.arm.backend.KvmBackend;
import com.github.unidbg.arm.backend.kvm.Kvm;
import com.github.unidbg.arm.backend.kvm.KvmException;
import com.github.unidbg.pointer.UnidbgPointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import keystone.Keystone;
import keystone.KeystoneArchitecture;
import keystone.KeystoneEncoded;
import keystone.KeystoneMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvmBackend32
extends KvmBackend {
    private static final Log log = LogFactory.getLog(KvmBackend32.class);
    private static final int EC_AA32_SVC = 17;
    private static final int EC_AA32_BKPT = 56;

    public KvmBackend32(Emulator<?> emulator, Kvm kvm) throws BackendException {
        super(emulator, kvm);
    }

    public void onInitialize() {
        super.onInitialize();
        this.mem_map(0xF0000000L, this.getPageSize(), 5);
        ByteBuffer buffer = ByteBuffer.allocate(this.getPageSize());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.hasRemaining()) {
            if (buffer.position() == 1536) {
                buffer.putInt(956302304);
            } else {
                buffer.putInt(956302305);
            }
            if (!buffer.hasRemaining()) continue;
            buffer.putInt(-694221856);
        }
        UnidbgPointer ptr = UnidbgPointer.pointer((Emulator)this.emulator, (long)0xF0000000L);
        assert (ptr != null);
        ptr.write(buffer.array());
    }

    @Override
    public boolean handleException(long esr, long far, long elr, long spsr, long pc) {
        int ec = (int)(esr >> 26 & 0x3FL);
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleException syndrome=0x" + Long.toHexString(esr) + ", far=0x" + Long.toHexString(far) + ", elr=0x" + Long.toHexString(elr) + ", ec=0x" + Integer.toHexString(ec) + ", pc=0x" + Long.toHexString(pc)));
        }
        switch (ec) {
            case 17: {
                int swi = (int)(esr & 0xFFFFL);
                this.callSVC(elr, swi);
                return true;
            }
            case 56: {
                int bkpt = (int)(esr & 0xFFFFL);
                this.interruptHookNotifier.notifyCallSVC((Backend)this, 7, bkpt);
                return true;
            }
        }
        throw new UnsupportedOperationException("handleException ec=0x" + Integer.toHexString(ec));
    }

    public void switchUserMode() {
    }

    public void enableVFP() {
        int value = this.reg_read(111).intValue();
        this.reg_write(111, value |= 0xF00000);
        this.reg_write(4, 0x40000000);
    }

    public Number reg_read(int regId) throws BackendException {
        try {
            switch (regId) {
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    return (int)(this.kvm.reg_read64(regId - 66) & 0xFFFFFFFFL);
                }
                case 12: {
                    return (int)(this.kvm.reg_read64(13) & 0xFFFFFFFFL);
                }
                case 10: {
                    return (int)(this.kvm.reg_read64(14) & 0xFFFFFFFFL);
                }
                case 11: {
                    return (int)(this.kvm.reg_read_pc64() & 0xFFFFFFFFL);
                }
                case 3: {
                    return this.kvm.reg_read_nzcv();
                }
                case 111: {
                    return this.kvm.reg_read_cpacr_el1();
                }
            }
            throw new KvmException("regId=" + regId);
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void reg_write(int regId, Number value) throws BackendException {
        try {
            switch (regId) {
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.kvm.reg_write64(regId - 66, value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                case 12: {
                    this.kvm.reg_write64(13, value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                case 10: {
                    this.kvm.reg_write64(14, value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                case 4: {
                    this.kvm.reg_set_fpexc(value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                case 113: {
                    this.kvm.reg_set_tpidrro_el0(value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                case 111: {
                    this.kvm.reg_set_cpacr_el1(value.longValue());
                    break;
                }
                case 3: {
                    this.kvm.reg_set_nzcv(value.longValue() & 0xFFFFFFFFL);
                    break;
                }
                default: {
                    throw new KvmException("regId=" + regId);
                }
            }
        }
        catch (KvmException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public byte[] reg_read_vector(int regId) throws BackendException {
        return null;
    }

    public void reg_write_vector(int regId, byte[] vector) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void debugger_add(DebugHook callback, long begin, long end, Object user_data) throws BackendException {
    }

    protected byte[] addSoftBreakPoint(long address, int svcNumber, boolean thumb) {
        try (Keystone keystone = new Keystone(KeystoneArchitecture.Arm, thumb ? KeystoneMode.ArmThumb : KeystoneMode.Arm);){
            KeystoneEncoded encoded = keystone.assemble("bkpt #" + svcNumber);
            byte[] byArray = encoded.getMachineCode();
            return byArray;
        }
    }
}

