/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.Generator;
import com.github.SnowFlakeConfiguration;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AtomicGenerator
implements Generator {
    private final SnowFlakeConfiguration configuration;
    private final long CONSTANT_DATA_CENTER;
    private final long CONSTANT_WORKER_ID;
    private final AtomicStampedReference<Long> reference = new AtomicStampedReference<Long>(-1L, 0);

    public AtomicGenerator(SnowFlakeConfiguration configuration) {
        Logger logger = Logger.getLogger("con.github.generator");
        logger.log(Level.INFO, "Initialized Atomic Generator for SnowFlake.");
        this.configuration = configuration;
        this.CONSTANT_DATA_CENTER = configuration.getDataCenterId() << (int)configuration.getDATA_CENTER_ID_OFFSET();
        this.CONSTANT_WORKER_ID = configuration.getWorkerId() << (int)configuration.getWORKER_ID_OFFSET();
    }

    @Override
    public long nextId() {
        int newSequence;
        int oldSequence;
        Long newTimestamp;
        Long oldTimestamp;
        do {
            oldTimestamp = this.reference.getReference();
            oldSequence = this.reference.getStamp();
            newTimestamp = new Long(System.currentTimeMillis());
            if (newTimestamp < oldTimestamp) {
                throw new RuntimeException("Current time is smaller than last timestamp");
            }
            if (newTimestamp.longValue() == oldTimestamp.longValue()) {
                newSequence = oldSequence + 1 & this.configuration.getSEQUENCE_MASK();
                if (newSequence != 0) continue;
                newTimestamp = new Long(this.nextMills(oldTimestamp));
                continue;
            }
            newSequence = 0;
        } while (!this.reference.compareAndSet(oldTimestamp, newTimestamp, oldSequence, newSequence));
        return newTimestamp - this.configuration.getINITIAL_TIME_STAMP() << (int)this.configuration.getTIME_STAMP_OFFSET() | this.CONSTANT_DATA_CENTER | this.CONSTANT_WORKER_ID | (long)newSequence;
    }

    private long nextMills(long lastTimestamp) {
        long timestamp;
        while ((timestamp = System.currentTimeMillis()) <= lastTimestamp) {
        }
        return timestamp;
    }
}

