/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.Generator;
import com.github.SnowFlakeConfiguration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedGenerator
implements Generator {
    private final SnowFlakeConfiguration configuration;
    private final StampedLock lock = new StampedLock();
    private final Queue<Long> queue;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public CachedGenerator(SnowFlakeConfiguration configuration) {
        Logger logger = Logger.getLogger("con.github.generator");
        logger.setLevel(Level.INFO);
        logger.info("Initialized Cached Generator for SnowFlake.");
        this.configuration = configuration;
        this.queue = new ConcurrentLinkedQueue<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId() {
        Long id;
        while ((id = this.queue.poll()) == null) {
            long stamp = this.lock.writeLock();
            try {
                if (this.queue.peek() != null) continue;
                int size = this.configuration.getPoolSize();
                for (int i = 0; i < size; ++i) {
                    this.generateIds();
                }
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
        return id;
    }

    private void generateIds() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("Current time is smaller than last timestamp");
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & (long)this.configuration.getSEQUENCE_MASK();
            if (this.sequence == 0L) {
                timestamp = this.tillNextMills(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long ans = timestamp - this.configuration.getINITIAL_TIME_STAMP() << (int)this.configuration.getTIME_STAMP_OFFSET() | this.configuration.getDataCenterId() << (int)this.configuration.getDATA_CENTER_ID_OFFSET() | this.configuration.getWorkerId() << (int)this.configuration.getWORKER_ID_OFFSET() | this.sequence;
        this.queue.offer(ans);
    }

    private long tillNextMills(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

