/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import com.github.AtomicGenerator;
import com.github.CachedGenerator;
import com.github.DefaultGenerator;
import com.github.Generator;
import com.github.SnowFlakeConfiguration;
import com.github.SnowFlakeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SnowFlakeProperties.class})
@ConditionalOnClass(value={SnowFlakeProperties.class})
public class SnowFlakeAutoConfiguration {
    @Autowired
    private SnowFlakeProperties properties;

    @Bean
    @ConditionalOnProperty(prefix="snowflake", name={"enable-cached", "enable-atomic"}, havingValue="false", matchIfMissing=true)
    public Generator getGenerator() {
        return new DefaultGenerator(SnowFlakeConfiguration.parse(this.properties));
    }

    @Bean
    @ConditionalOnProperty(prefix="snowflake", name={"enable-cached"}, havingValue="true")
    public Generator getQueuedGenerator() {
        return new CachedGenerator(SnowFlakeConfiguration.parse(this.properties));
    }

    @Bean
    @ConditionalOnProperty(prefix="snowflake", name={"enable-atomic"}, havingValue="true")
    public Generator getAtomicGenerator() {
        return new AtomicGenerator(SnowFlakeConfiguration.parse(this.properties));
    }
}

