/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zthulj.zcopybook.model.Coordinates;
import com.github.zthulj.zcopybook.model.ValueNode;
import com.github.zthulj.zcopybook.model.ZCopyBook;

public class ZConverter {
    private final ZCopyBook<String> copyBook;
    private ObjectMapper mapperJson = new ObjectMapper();

    public String convertToJson(String positionalLine) throws JsonProcessingException {
        if (null == positionalLine) {
            throw new IllegalArgumentException("positionalLine can't be null");
        }
        if (positionalLine.length() != this.copyBook.getWaitedLength()) {
            throw new IllegalArgumentException("Waited length : " + this.copyBook.getWaitedLength() + ", actual positionnalLine length : " + positionalLine.length());
        }
        for (ValueNode<String> valueNode : this.copyBook.getValueNodes()) {
            Coordinates c = valueNode.getCoordinates();
            valueNode.setValue(positionalLine.substring(c.getStart(), c.getEnd()));
        }
        return this.mapperJson.writeValueAsString(this.copyBook.getRootNode());
    }

    public ZConverter(ZCopyBook<String> copyBook) {
        this.copyBook = copyBook;
    }
}

