/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.engine;

import com.github.zthulj.zcopybook.factory.NodeFactory;
import com.github.zthulj.zcopybook.model.Coordinates;
import com.github.zthulj.zcopybook.model.ParentArrayNode;
import com.github.zthulj.zcopybook.model.ParentNode;
import com.github.zthulj.zcopybook.model.RootNode;
import com.github.zthulj.zcopybook.model.ValueNode;
import com.github.zthulj.zcopybook.model.ZCopyBook;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZLoader {
    private static Logger logger = LoggerFactory.getLogger(ZLoader.class);
    private static final Pattern parentPattern = Pattern.compile("([^ ]*?)( {1})([^ ]*?)");
    private static final Pattern levelNbPattern = Pattern.compile("([^ ]*?)( {1})(.*?)");
    private static final Pattern simpleValuePattern = Pattern.compile("([^ ]*?)( {1})([^ ]*?)( {1})([^ ]*?)( {1})([^ ]*)");
    private static final Pattern parentArrayPattern = Pattern.compile("([^ ]*?)( {1})([^ ]*?)( {1})(OCCURS)( {1})([^ ]*)");
    private static final Pattern redefineParentPattern = Pattern.compile("([^ ]*?)( {1})([^ ]*?)( {1})(REDEFINES)( {1})([^ ]*)");
    private static final Pattern picX_n_Pattern = Pattern.compile("(X|9)(\\({1})([^\\)]*?)(\\){1})");
    private static final Pattern picS9_n_v99_Pattern = Pattern.compile("(S9)(\\({1})([^\\)]*?)(\\){1})(V)(9*)");
    private static final Pattern picS9_n_Pattern = Pattern.compile("(S9)(\\({1})([^\\)]*?)(\\){1})");
    private static final Pattern picX_pattern = Pattern.compile("X*");

    public ZCopyBook load(File copybook) throws IOException {
        if (copybook == null) {
            throw new IllegalArgumentException("copybook can't be null !");
        }
        return this.load(copybook, StandardCharsets.UTF_8);
    }

    public ZCopyBook load(File copybook, Charset charset) throws IOException {
        if (null == copybook || null == charset) {
            throw new IllegalArgumentException("copybook and charset can't be null !");
        }
        return this.load(FileUtils.readFileToString((File)copybook, (Charset)charset));
    }

    public ZCopyBook load(String copybook) {
        if (null == copybook) {
            throw new IllegalArgumentException("copybook can't be null !");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Started the conversion of the copybook : %n[%n%s%n]", copybook));
        }
        RootNode root = NodeFactory.createRootNode();
        Cursor cursor = new Cursor(root);
        List<String> cleanedCopybook = this.cleanCopybook(copybook);
        boolean inANodeToIgnore = false;
        int levelToIgnore = 0;
        for (String line : cleanedCopybook) {
            Matcher redefineParentMatcher;
            int levelNb = this.getLevelNbFromLine(line);
            if (inANodeToIgnore && levelNb <= levelToIgnore) {
                inANodeToIgnore = false;
            }
            if ((redefineParentMatcher = redefineParentPattern.matcher(line)).matches()) {
                inANodeToIgnore = true;
                levelToIgnore = levelNb;
            }
            if (inANodeToIgnore) {
                logger.debug("Ignoring line : {}.", (Object)line);
                continue;
            }
            this.updateCursorWithCurrentLevelNb(cursor, levelNb);
            boolean handled = this.handleSimpleParent(line, cursor, levelNb);
            if (!handled) {
                handled = this.handleOccursParent(line, cursor, levelNb);
            }
            if (handled) continue;
            this.handleValue(line, cursor);
        }
        if (cursor.lastParent instanceof ParentArrayNode) {
            ((ParentArrayNode)cursor.lastParent).duplicateOccurs(cursor.cursorPosition);
        }
        return ZCopyBook.from(root);
    }

    private List<String> cleanCopybook(String copybook) {
        String cleanedLinedCopybook = this.cleanLines(copybook);
        ArrayList<String> cleanedCopybook = new ArrayList<String>();
        for (String field : cleanedLinedCopybook.split("\\.")) {
            cleanedCopybook.add(field.trim());
        }
        return cleanedCopybook;
    }

    private String cleanLines(String copybook) {
        StringBuilder builder = new StringBuilder();
        for (String line : copybook.split("\\n")) {
            if (!this.lineShouldBeAdded(line)) continue;
            builder.append(" ").append(line.trim());
        }
        return builder.toString().replaceAll(" +", " ");
    }

    private boolean lineShouldBeAdded(String line) {
        boolean shouldBeIgnored;
        boolean bl = shouldBeIgnored = line.trim().startsWith("*") || line.trim().startsWith("88");
        if (shouldBeIgnored) {
            logger.debug("Ignoring line : {}", (Object)line);
        }
        return !shouldBeIgnored;
    }

    private int getLevelNbFromLine(String line) {
        Matcher matcher = levelNbPattern.matcher(line);
        if (!matcher.matches()) {
            return 0;
        }
        return Integer.parseInt(matcher.group(1));
    }

    private void updateCursorWithCurrentLevelNb(Cursor cursor, int levelNb) {
        while (cursor.lastParent != null && levelNb <= cursor.lastParent.getLevelNumber()) {
            if (cursor.lastParent instanceof ParentArrayNode) {
                cursor.cursorPosition = ((ParentArrayNode)cursor.lastParent).duplicateOccurs(cursor.cursorPosition);
            }
            cursor.lastParent = cursor.lastParent.getParentNode();
        }
    }

    private boolean handleSimpleParent(String line, Cursor cursor, int levelNb) {
        Matcher nodeMatcher = parentPattern.matcher(line);
        if (nodeMatcher.matches()) {
            ParentNode newParent = NodeFactory.createParentNode(cursor.lastParent, levelNb);
            cursor.lastParent.addChild(newParent, nodeMatcher.group(3));
            cursor.lastParent = newParent;
            return true;
        }
        return false;
    }

    private boolean handleOccursParent(String line, Cursor cursor, int levelNb) {
        Matcher occursMatcher = parentArrayPattern.matcher(line);
        if (occursMatcher.matches()) {
            int occursNb = Integer.parseInt(occursMatcher.group(7));
            ParentArrayNode newParent = NodeFactory.createParentNodeArray(cursor.lastParent, levelNb, occursNb);
            cursor.lastParent.addChild(newParent, occursMatcher.group(3));
            cursor.lastParent = newParent;
            return true;
        }
        return false;
    }

    private void handleValue(String line, Cursor cursor) {
        Matcher valueMatcher = simpleValuePattern.matcher(line);
        if (valueMatcher.matches()) {
            cursor.cursorPosition = this.addValueNode(cursor.lastParent, cursor.cursorPosition, valueMatcher);
        }
    }

    private int addValueNode(ParentNode lastParent, int nextStart, Matcher valueMatcher) {
        int fieldSize = 0;
        ValueNode.ValueType type = ValueNode.ValueType.STRING;
        String dataType = valueMatcher.group(7);
        Matcher defaultMatcher = picX_n_Pattern.matcher(dataType);
        Matcher signedIntMatcher = picS9_n_Pattern.matcher(dataType);
        Matcher signedFloatMatcher = picS9_n_v99_Pattern.matcher(dataType);
        Matcher picXMatcher = picX_pattern.matcher(dataType);
        if (defaultMatcher.matches()) {
            fieldSize = Integer.parseInt(defaultMatcher.group(3));
        } else if (signedFloatMatcher.matches()) {
            fieldSize = Integer.parseInt(signedFloatMatcher.group(3)) + signedFloatMatcher.group(6).length();
            type = ValueNode.ValueType.SIGNED_FLOAT;
        } else if (signedIntMatcher.matches()) {
            fieldSize = Integer.parseInt(signedIntMatcher.group(3));
            type = ValueNode.ValueType.SIGNED_INT;
        } else if (picXMatcher.matches()) {
            fieldSize = dataType.length();
        }
        ValueNode node = NodeFactory.createValueNode(lastParent, Coordinates.create(nextStart, nextStart + fieldSize), type);
        lastParent.addChild(node, valueMatcher.group(3));
        return nextStart += fieldSize;
    }

    class Cursor {
        int cursorPosition;
        ParentNode lastParent;

        public Cursor(ParentNode lastParent) {
            this.lastParent = lastParent;
            this.cursorPosition = 0;
        }
    }
}

