/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.factory;

import com.github.zthulj.zcopybook.model.Coordinates;
import com.github.zthulj.zcopybook.model.ParentArrayNode;
import com.github.zthulj.zcopybook.model.ParentNode;
import com.github.zthulj.zcopybook.model.RootNode;
import com.github.zthulj.zcopybook.model.ValueNode;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class NodeFactory {
    public static <T extends Serializable> RootNode<T> createRootNode() {
        return new RootNode(new LinkedHashMap());
    }

    public static <T extends Serializable> ParentNode<T> createParentNode(ParentNode<T> parent, int lvlNumber) {
        return new ParentNode<T>(parent, new LinkedHashMap(), lvlNumber);
    }

    public static <T extends Serializable> ValueNode<T> createValueNode(ParentNode<T> parent, Coordinates coords) {
        return NodeFactory.createValueNode(parent, coords, ValueNode.ValueType.STRING);
    }

    public static <T extends Serializable> ValueNode<T> createValueNode(ParentNode<T> parent, Coordinates coords, ValueNode.ValueType type) {
        return new ValueNode<T>(parent, coords, type);
    }

    public static <T extends Serializable> ParentArrayNode<T> createParentNodeArray(ParentNode<T> parent, int lvlNumber, int occursNumber) {
        return new ParentArrayNode<T>(parent, lvlNumber, occursNumber);
    }

    private NodeFactory() {
    }
}

