/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.model;

import java.io.Serializable;

public final class Coordinates
implements Serializable {
    private static final long serialVersionUID = 6100935963637812753L;
    private final int start;
    private final int end;

    public static Coordinates create(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end can't be less than start. It should be at least equal");
        }
        return new Coordinates(start, end);
    }

    public int getSize() {
        return this.end - this.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Coordinates)) {
            return false;
        }
        Coordinates other = (Coordinates)o;
        if (this.getStart() != other.getStart()) {
            return false;
        }
        return this.getEnd() == other.getEnd();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStart();
        result = result * 59 + this.getEnd();
        return result;
    }

    private Coordinates(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return "Coordinates(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }
}

