/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.zthulj.zcopybook.factory.NodeFactory;
import com.github.zthulj.zcopybook.model.Node;
import com.github.zthulj.zcopybook.model.ParentNode;
import com.github.zthulj.zcopybook.model.ValueNode;
import com.github.zthulj.zcopybook.serializer.ParentArrayNodeSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=ParentArrayNodeSerializer.class)
public class ParentArrayNode<T extends Serializable>
extends ParentNode<T> {
    private static final long serialVersionUID = 943387055163029210L;
    private final ParentNode<T>[] childArray;

    public ParentArrayNode(ParentNode<T> parent, int levelNumber, int occursNumber) {
        super(parent, null, levelNumber);
        if (occursNumber < 1) {
            throw new IllegalArgumentException("OccursNumber can't be less than 1");
        }
        this.childArray = new ParentNode[occursNumber];
        for (int i = 0; i < occursNumber; ++i) {
            this.childArray[i] = NodeFactory.createParentNode(parent, levelNumber);
        }
    }

    public int duplicateOccurs(int nextStart) {
        ParentNode<T> model = this.childArray[0];
        for (int i = 1; i < this.childArray.length; ++i) {
            for (Map.Entry<String, Node<T>> entry : model.getChilds().entrySet()) {
                nextStart = entry.getValue().copyInto(this.childArray[i], nextStart, entry.getKey());
            }
        }
        return nextStart;
    }

    @Override
    public int copyInto(ParentNode<T> destination, int cursorPosition, String name) {
        ParentArrayNode<T> newParentArray = NodeFactory.createParentNodeArray(destination, this.getLevelNumber(), this.childArray.length);
        destination.addChild(newParentArray, name);
        for (int i = 0; i < this.getChildArray().length; ++i) {
            cursorPosition = this.copyChild(cursorPosition, this.getChildArray()[i], newParentArray.getChildArray()[i]);
        }
        return cursorPosition;
    }

    private int copyChild(int cursorPosition, ParentNode<T> source, ParentNode<T> destination) {
        for (Map.Entry<String, Node<T>> childEntry : source.getChilds().entrySet()) {
            cursorPosition = childEntry.getValue().copyInto(destination, cursorPosition, childEntry.getKey());
        }
        return cursorPosition;
    }

    @Override
    public void addChild(Node<T> node, String nodeName) {
        this.childArray[0].addChild(node, nodeName);
    }

    @Override
    public List<ValueNode<T>> getAllValueNodes() {
        ArrayList<ValueNode<T>> allValueNodes = new ArrayList<ValueNode<T>>();
        for (int i = 0; i < this.childArray.length; ++i) {
            allValueNodes.addAll(this.childArray[i].getAllValueNodes());
        }
        return allValueNodes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentArrayNode)) {
            return false;
        }
        ParentArrayNode other = (ParentArrayNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getChildArray(), other.getChildArray());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ParentArrayNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getChildArray());
        return result;
    }

    public ParentNode<T>[] getChildArray() {
        return this.childArray;
    }

    @Override
    public String toString() {
        return "ParentArrayNode(childArray=" + Arrays.deepToString(this.getChildArray()) + ")";
    }
}

