/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.zthulj.zcopybook.factory.NodeFactory;
import com.github.zthulj.zcopybook.model.Node;
import com.github.zthulj.zcopybook.model.ValueNode;
import com.github.zthulj.zcopybook.serializer.ParentNodeSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=ParentNodeSerializer.class)
public class ParentNode<T extends Serializable>
extends Node<T> {
    private static final long serialVersionUID = -7011113266458098086L;
    private final Map<String, Node<T>> childs;
    private final int levelNumber;

    public ParentNode(ParentNode<T> parent, Map<String, Node<T>> childs, int levelNumber) {
        super(parent, true);
        this.childs = childs;
        this.levelNumber = levelNumber;
    }

    public void addChild(Node<T> child, String name) {
        this.getChilds().put(this.getFinalName(name), child);
    }

    @Override
    public int copyInto(ParentNode<T> destination, int cursorPosition, String name) {
        ParentNode<T> current = NodeFactory.createParentNode(destination, this.levelNumber);
        destination.addChild(current, name);
        for (Map.Entry<String, Node<T>> childEntry : this.getChilds().entrySet()) {
            cursorPosition = childEntry.getValue().copyInto(current, cursorPosition, childEntry.getKey());
        }
        return cursorPosition;
    }

    private String getFinalName(String nodeName) {
        String name = nodeName;
        int i = 1;
        while (this.getChilds().containsKey(name)) {
            name = nodeName + ++i;
        }
        return name;
    }

    @Override
    public List<ValueNode<T>> getAllValueNodes() {
        ArrayList allValueNodes = new ArrayList();
        this.childs.forEach((k, v) -> allValueNodes.addAll(v.getAllValueNodes()));
        return allValueNodes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentNode)) {
            return false;
        }
        ParentNode other = (ParentNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Node<T>> this$childs = this.getChilds();
        Map<String, Node<T>> other$childs = other.getChilds();
        if (this$childs == null ? other$childs != null : !((Object)this$childs).equals(other$childs)) {
            return false;
        }
        return this.getLevelNumber() == other.getLevelNumber();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ParentNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Node<T>> $childs = this.getChilds();
        result = result * 59 + ($childs == null ? 43 : ((Object)$childs).hashCode());
        result = result * 59 + this.getLevelNumber();
        return result;
    }

    public Map<String, Node<T>> getChilds() {
        return this.childs;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    @Override
    public String toString() {
        return "ParentNode(childs=" + this.getChilds() + ", levelNumber=" + this.getLevelNumber() + ")";
    }
}

