/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.zthulj.zcopybook.factory.NodeFactory;
import com.github.zthulj.zcopybook.model.Coordinates;
import com.github.zthulj.zcopybook.model.Node;
import com.github.zthulj.zcopybook.model.ParentNode;
import com.github.zthulj.zcopybook.serializer.ValueNodeSerializer;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@JsonSerialize(using=ValueNodeSerializer.class)
public final class ValueNode<T extends Serializable>
extends Node<T> {
    private static final long serialVersionUID = -3833993476849963456L;
    private T value;
    private final Coordinates coordinates;
    private final ValueType valueType;

    public ValueNode(ParentNode<T> parent, Coordinates coordinates, ValueType valueType) {
        super(parent, false);
        this.coordinates = coordinates;
        this.valueType = valueType;
    }

    @Override
    public int copyInto(ParentNode<T> destination, int cursorPosition, String name) {
        Coordinates nextCoords = this.calculateCoordinates(this, cursorPosition);
        ValueNode<T> valueNode = NodeFactory.createValueNode(destination, nextCoords, this.valueType);
        destination.addChild(valueNode, name);
        return cursorPosition += nextCoords.getSize();
    }

    private Coordinates calculateCoordinates(ValueNode<T> value, int nextStart) {
        return Coordinates.create(nextStart, nextStart + value.getCoordinates().getSize());
    }

    @Override
    public List<ValueNode<T>> getAllValueNodes() {
        return Collections.singletonList(this);
    }

    public T getValue() {
        return this.value;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueNode)) {
            return false;
        }
        ValueNode other = (ValueNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Coordinates this$coordinates = this.getCoordinates();
        Coordinates other$coordinates = other.getCoordinates();
        if (this$coordinates == null ? other$coordinates != null : !((Object)this$coordinates).equals(other$coordinates)) {
            return false;
        }
        ValueType this$valueType = this.getValueType();
        ValueType other$valueType = other.getValueType();
        return !(this$valueType == null ? other$valueType != null : !((Object)((Object)this$valueType)).equals((Object)other$valueType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ValueNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Coordinates $coordinates = this.getCoordinates();
        result = result * 59 + ($coordinates == null ? 43 : ((Object)$coordinates).hashCode());
        ValueType $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : ((Object)((Object)$valueType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ValueNode(value=" + this.getValue() + ", coordinates=" + this.getCoordinates() + ", valueType=" + (Object)((Object)this.getValueType()) + ")";
    }

    public static enum ValueType {
        STRING,
        SIGNED_INT,
        SIGNED_FLOAT;

    }
}

