/*
 * Decompiled with CFR 0.152.
 */
package com.github.zthulj.zcopybook.model;

import com.github.zthulj.zcopybook.model.RootNode;
import com.github.zthulj.zcopybook.model.ValueNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class ZCopyBook<T extends Serializable> {
    private final RootNode<T> rootNode;
    private List<ValueNode<T>> valueNodes;
    private int waitedLength;

    public static <T extends Serializable> ZCopyBook<T> from(RootNode<T> rootNodeCopybook) {
        ArrayList allValueNodes = new ArrayList();
        rootNodeCopybook.getChilds().forEach((k, v) -> allValueNodes.addAll(v.getAllValueNodes()));
        int waited = allValueNodes.stream().mapToInt(e -> e.getCoordinates().getSize()).sum();
        return new ZCopyBook<T>(rootNodeCopybook, allValueNodes, waited);
    }

    public RootNode<T> getRootNode() {
        return this.rootNode;
    }

    public List<ValueNode<T>> getValueNodes() {
        return this.valueNodes;
    }

    public int getWaitedLength() {
        return this.waitedLength;
    }

    public ZCopyBook(RootNode<T> rootNode) {
        this.rootNode = rootNode;
    }

    private ZCopyBook(RootNode<T> rootNode, List<ValueNode<T>> valueNodes, int waitedLength) {
        this.rootNode = rootNode;
        this.valueNodes = valueNodes;
        this.waitedLength = waitedLength;
    }
}

