/*
 * Decompiled with CFR 0.152.
 */
package com.github.zuihou.cache;

import com.github.zuihou.cache.lock.RedisDistributedLock;
import com.github.zuihou.cache.properties.CustomCacheProperties;
import com.github.zuihou.cache.repository.CacheRepository;
import com.github.zuihou.cache.repository.RedisRepositoryImpl;
import com.github.zuihou.cache.utils.RedisObjectSerializer;
import com.github.zuihou.lock.DistributedLock;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@ConditionalOnClass(value={RedisConnectionFactory.class})
@ConditionalOnProperty(name={"zuihou.cache.type"}, havingValue="REDIS", matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class, CustomCacheProperties.class})
public class RedisAutoConfigure {
    @Autowired
    private CustomCacheProperties cacheProperties;

    @Bean
    @ConditionalOnMissingBean
    public DistributedLock RedisDistributedLock(RedisTemplate<String, Object> redisTemplate) {
        return new RedisDistributedLock(redisTemplate);
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(factory);
        RedisObjectSerializer redisObjectSerializer = new RedisObjectSerializer();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)redisObjectSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)redisObjectSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheRepository redisRepository(RedisTemplate<String, Object> redisTemplate) {
        return new RedisRepositoryImpl(redisTemplate);
    }

    @Bean(name={"cacheManager"})
    @Primary
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        RedisCacheConfiguration defConfig = this.getDefConf();
        defConfig.entryTtl(this.cacheProperties.getDef().getTimeToLive());
        Map<String, CustomCacheProperties.Cache> configs = this.cacheProperties.getConfigs();
        HashMap map = Maps.newHashMap();
        Optional.ofNullable(configs).ifPresent(config -> config.forEach((key, cache) -> {
            RedisCacheConfiguration cfg = this.handleRedisCacheConfiguration((CustomCacheProperties.Cache)cache, defConfig);
            map.put(key, cfg);
        }));
        return RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(defConfig).withInitialCacheConfigurations((Map)map).build();
    }

    private RedisCacheConfiguration getDefConf() {
        RedisCacheConfiguration def = RedisCacheConfiguration.defaultCacheConfig().disableCachingNullValues().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new RedisObjectSerializer()));
        return this.handleRedisCacheConfiguration(this.cacheProperties.getDef(), def);
    }

    private RedisCacheConfiguration handleRedisCacheConfiguration(CustomCacheProperties.Cache redisProperties, RedisCacheConfiguration config) {
        if (Objects.isNull(redisProperties)) {
            return config;
        }
        if (redisProperties.getTimeToLive() != null) {
            config = config.entryTtl(redisProperties.getTimeToLive());
        }
        config = redisProperties.getKeyPrefix() != null ? config.computePrefixWith(cacheName -> redisProperties.getKeyPrefix().concat(":").concat(cacheName).concat(":")) : config.computePrefixWith(cacheName -> cacheName.concat(":"));
        if (!redisProperties.isCacheNullValues()) {
            config = config.disableCachingNullValues();
        }
        if (!redisProperties.isUseKeyPrefix()) {
            config = config.disableKeyPrefix();
        }
        return config;
    }
}

