/*
 * Decompiled with CFR 0.152.
 */
package com.github.zxl0714.redismock;

import com.github.zxl0714.redismock.RedisBase;
import com.github.zxl0714.redismock.RedisCommand;
import com.github.zxl0714.redismock.Response;
import com.github.zxl0714.redismock.Slice;
import com.github.zxl0714.redismock.Utils;
import com.github.zxl0714.redismock.expecptions.InternalException;
import com.github.zxl0714.redismock.expecptions.WrongNumberOfArgumentsException;
import com.github.zxl0714.redismock.expecptions.WrongValueTypeException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class CommandExecutor {
    private final RedisBase base;

    public static List<String> getSupportedCommands() {
        Method[] methods;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Method method : methods = CommandExecutor.class.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1 || !params[0].getName().equals(List.class.getName()) || !method.getReturnType().getName().equals(Slice.class.getName())) continue;
            builder.add((Object)method.getName());
        }
        return builder.build();
    }

    public CommandExecutor(RedisBase base) {
        this.base = base;
    }

    public Slice set(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 2);
        this.base.rawPut(params.get(0), params.get(1), -1L);
        return Response.OK;
    }

    public Slice setex(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 3);
        try {
            long ttl = Long.parseLong(new String(params.get(1).data())) * 1000L;
            this.base.rawPut(params.get(0), params.get(2), ttl);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
        return Response.OK;
    }

    public Slice psetex(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 3);
        try {
            long ttl = Long.parseLong(new String(params.get(1).data()));
            this.base.rawPut(params.get(0), params.get(2), ttl);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
        return Response.OK;
    }

    public Slice setnx(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 2);
        if (this.base.rawGet(params.get(0)) == null) {
            this.base.rawPut(params.get(0), params.get(1), -1L);
            return Response.integer(1L);
        }
        return Response.integer(0L);
    }

    public Slice setbit(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        long original;
        int pos;
        byte bit;
        Utils.checkArgumentsNumberEquals(params, 3);
        Slice value = this.base.rawGet(params.get(0));
        try {
            bit = Byte.parseByte(params.get(2).toString());
            if (bit != 0 && bit != 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR bit is not an integer or out of range");
        }
        try {
            pos = Integer.parseInt(params.get(1).toString());
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR bit offset is not an integer or out of range");
        }
        if (pos < 0) {
            throw new WrongValueTypeException("ERR bit offset is not an integer or out of range");
        }
        if (value == null) {
            byte[] data = new byte[pos / 8 + 1];
            Arrays.fill(data, (byte)0);
            data[pos / 8] = (byte)(bit << pos % 8);
            this.base.rawPut(params.get(0), new Slice(data), -1L);
            return Response.integer(0L);
        }
        if (pos / 8 >= value.length()) {
            byte[] data = new byte[pos / 8 + 1];
            Arrays.fill(data, (byte)0);
            for (int i = 0; i < value.length(); ++i) {
                data[i] = value.data()[i];
            }
            data[pos / 8] = (byte)(bit << pos % 8);
            original = 0L;
            this.base.rawPut(params.get(0), new Slice(data), -1L);
        } else {
            byte[] data = value.data();
            original = (data[pos / 8] & 1 << pos % 8) != 0 ? 1L : 0L;
            int n = pos / 8;
            data[n] = (byte)(data[n] | (byte)(1 << pos % 8));
            int n2 = pos / 8;
            data[n2] = (byte)(data[n2] & (byte)(bit << pos % 8));
            this.base.rawPut(params.get(0), new Slice(data), -1L);
        }
        return Response.integer(original);
    }

    public Slice append(List<Slice> params) throws WrongNumberOfArgumentsException {
        int i;
        Utils.checkArgumentsNumberEquals(params, 2);
        Slice key = params.get(0);
        Slice value = params.get(1);
        Slice s = this.base.rawGet(key);
        if (s == null) {
            this.base.rawPut(key, value, -1L);
            return Response.integer(value.length());
        }
        byte[] b = new byte[s.length() + value.length()];
        for (i = 0; i < s.length(); ++i) {
            b[i] = s.data()[i];
        }
        for (i = s.length(); i < s.length() + value.length(); ++i) {
            b[i] = value.data()[i - s.length()];
        }
        this.base.rawPut(key, new Slice(b), -1L);
        return Response.integer(b.length);
    }

    public Slice get(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 1);
        Slice value = this.base.rawGet(params.get(0));
        return Response.bulkString(value);
    }

    public Slice getbit(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        int pos;
        Utils.checkArgumentsNumberEquals(params, 2);
        Slice value = this.base.rawGet(params.get(0));
        try {
            pos = Integer.parseInt(params.get(1).toString());
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR bit offset is not an integer or out of range");
        }
        if (pos < 0) {
            throw new WrongValueTypeException("ERR bit offset is not an integer or out of range");
        }
        if (value == null) {
            return Response.integer(0L);
        }
        if (pos >= value.length() * 8) {
            return Response.integer(0L);
        }
        if ((value.data()[pos / 8] & 1 << pos % 8) != 0) {
            return Response.integer(1L);
        }
        return Response.integer(0L);
    }

    public Slice ttl(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 1);
        Long pttl = this.base.getTTL(params.get(0));
        if (pttl == null) {
            return Response.integer(-2L);
        }
        if (pttl == -1L) {
            return Response.integer(-1L);
        }
        return Response.integer((pttl + 999L) / 1000L);
    }

    public Slice pttl(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 1);
        Long pttl = this.base.getTTL(params.get(0));
        if (pttl == null) {
            return Response.integer(-2L);
        }
        if (pttl == -1L) {
            return Response.integer(-1L);
        }
        return Response.integer(pttl);
    }

    public Slice expire(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 2);
        try {
            long pttl = Long.parseLong(new String(params.get(1).data())) * 1000L;
            return Response.integer(this.base.setTTL(params.get(0), pttl));
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice pexpire(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 2);
        try {
            long pttl = Long.parseLong(new String(params.get(1).data()));
            return Response.integer(this.base.setTTL(params.get(0), pttl));
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice incr(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 1);
        Slice key = params.get(0);
        Slice v = this.base.rawGet(key);
        if (v == null) {
            this.base.rawPut(key, new Slice("1"), -1L);
            return Response.integer(1L);
        }
        try {
            long r = Long.parseLong(new String(v.data())) + 1L;
            this.base.rawPut(key, new Slice(String.valueOf(r)), -1L);
            return Response.integer(r);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice incrby(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 2);
        try {
            Slice key = params.get(0);
            long d = Long.parseLong(String.valueOf(params.get(1)));
            Slice v = this.base.rawGet(key);
            if (v == null) {
                this.base.rawPut(key, new Slice(String.valueOf(d)), -1L);
                return Response.integer(d);
            }
            long r = Long.parseLong(new String(v.data())) + d;
            this.base.rawPut(key, new Slice(String.valueOf(r)), -1L);
            return Response.integer(r);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice decr(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 1);
        Slice key = params.get(0);
        Slice v = this.base.rawGet(key);
        if (v == null) {
            this.base.rawPut(key, new Slice("-1"), -1L);
            return Response.integer(-1L);
        }
        try {
            long r = Long.parseLong(new String(v.data())) - 1L;
            this.base.rawPut(key, new Slice(String.valueOf(r)), -1L);
            return Response.integer(r);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice decrby(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 2);
        try {
            Slice key = params.get(0);
            long d = Long.parseLong(String.valueOf(params.get(1)));
            Slice v = this.base.rawGet(key);
            if (v == null) {
                this.base.rawPut(key, new Slice(String.valueOf(-d)), -1L);
                return Response.integer(-d);
            }
            long r = Long.parseLong(new String(v.data())) - d;
            this.base.rawPut(key, new Slice(String.valueOf(r)), -1L);
            return Response.integer(r);
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice pfcount(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberGreater(params, 0);
        HashSet set = Sets.newHashSet();
        for (Slice key : params) {
            Slice data = this.base.rawGet(key);
            if (data == null) continue;
            try {
                Set s = (Set)Utils.deserializeObject(data);
                set.addAll(s);
            }
            catch (Exception e) {
                throw new WrongValueTypeException("WRONGTYPE Key is not a valid HyperLogLog string value.");
            }
        }
        return Response.integer(set.size());
    }

    public Slice pfadd(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException, InternalException {
        int prev;
        boolean first;
        Set<Slice> set;
        Utils.checkArgumentsNumberGreater(params, 1);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        if (data == null) {
            set = Sets.newHashSet();
            first = true;
            prev = 0;
        } else {
            try {
                set = (Set)Utils.deserializeObject(data);
            }
            catch (Exception e) {
                throw new WrongValueTypeException("WRONGTYPE Key is not a valid HyperLogLog string value.");
            }
            first = false;
            prev = set.size();
        }
        for (Slice v : params.subList(1, params.size())) {
            set.add(v);
        }
        try {
            Slice out = Utils.serializeObject(set);
            if (first) {
                this.base.rawPut(key, out, -1L);
            } else {
                this.base.rawPut(key, out, null);
            }
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
        if (prev != set.size()) {
            return Response.integer(1L);
        }
        return Response.integer(0L);
    }

    public Slice pfmerge(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException, InternalException {
        boolean first;
        Set set;
        Utils.checkArgumentsNumberGreater(params, 0);
        Slice dst = params.get(0);
        Slice data = this.base.rawGet(dst);
        if (data == null) {
            set = Sets.newHashSet();
            first = true;
        } else {
            try {
                set = (Set)Utils.deserializeObject(data);
            }
            catch (Exception e) {
                throw new WrongValueTypeException("WRONGTYPE Key is not a valid HyperLogLog string value.");
            }
            first = false;
        }
        for (Slice v : params.subList(1, params.size())) {
            Slice src = this.base.rawGet(v);
            if (src == null) continue;
            try {
                Set s = (Set)Utils.deserializeObject(src);
                set.addAll(s);
            }
            catch (Exception e) {
                throw new WrongValueTypeException("WRONGTYPE Key is not a valid HyperLogLog string value.");
            }
        }
        try {
            Slice out = Utils.serializeObject(set);
            if (first) {
                this.base.rawPut(dst, out, -1L);
            } else {
                this.base.rawPut(dst, out, null);
            }
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
        return Response.OK;
    }

    public Slice mget(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberGreater(params, 0);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Slice key : params) {
            builder.add((Object)Response.bulkString(this.base.rawGet(key)));
        }
        return Response.array((List<Slice>)builder.build());
    }

    public Slice mset(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberGreater(params, 0);
        Utils.checkArgumentsNumberFactor(params, 2);
        for (int i = 0; i < params.size(); i += 2) {
            this.base.rawPut(params.get(i), params.get(i + 1), -1L);
        }
        return Response.OK;
    }

    public Slice getset(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 2);
        Slice value = this.base.rawGet(params.get(0));
        this.base.rawPut(params.get(0), params.get(1), -1L);
        return Response.bulkString(value);
    }

    public Slice strlen(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 1);
        Slice value = this.base.rawGet(params.get(0));
        if (value == null) {
            return Response.integer(0L);
        }
        return Response.integer(value.length());
    }

    public Slice del(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberGreater(params, 0);
        int count = 0;
        for (Slice key : params) {
            Slice value = this.base.rawGet(key);
            this.base.del(key);
            if (value == null) continue;
            ++count;
        }
        return Response.integer(count);
    }

    public Slice exists(List<Slice> params) throws WrongNumberOfArgumentsException {
        Utils.checkArgumentsNumberEquals(params, 1);
        if (this.base.rawGet(params.get(0)) != null) {
            return Response.integer(1L);
        }
        return Response.integer(0L);
    }

    public Slice expireat(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 2);
        try {
            long deadline = Long.parseLong(new String(params.get(1).data())) * 1000L;
            return Response.integer(this.base.setDeadline(params.get(0), deadline));
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice pexpireat(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        Utils.checkArgumentsNumberEquals(params, 2);
        try {
            long deadline = Long.parseLong(new String(params.get(1).data()));
            return Response.integer(this.base.setDeadline(params.get(0), deadline));
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
    }

    public Slice lpush(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException, InternalException {
        LinkedList list;
        Utils.checkArgumentsNumberGreater(params, 1);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            list = data != null ? (LinkedList)Utils.deserializeObject(data) : Lists.newLinkedList();
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        for (int i = 1; i < params.size(); ++i) {
            list.addFirst(params.get(i));
        }
        try {
            this.base.rawPut(key, Utils.serializeObject(list), -1L);
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
        return Response.integer(list.size());
    }

    public Slice lpushx(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException, InternalException {
        LinkedList list;
        Utils.checkArgumentsNumberGreater(params, 1);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            if (data == null) {
                return Response.integer(0L);
            }
            list = (LinkedList)Utils.deserializeObject(data);
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        for (int i = 1; i < params.size(); ++i) {
            list.addFirst(params.get(i));
        }
        try {
            this.base.rawPut(key, Utils.serializeObject(list), -1L);
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
        return Response.integer(list.size());
    }

    public Slice lrange(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        int end;
        int start;
        LinkedList list;
        Utils.checkArgumentsNumberEquals(params, 3);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            list = data != null ? (LinkedList)Utils.deserializeObject(data) : Lists.newLinkedList();
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        try {
            start = Integer.parseInt(params.get(1).toString());
            end = Integer.parseInt(params.get(2).toString());
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
        if (start < 0 && (start = list.size() + start) < 0) {
            start = 0;
        }
        if (end < 0 && (end = list.size() + end) < 0) {
            end = 0;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = start; i <= end && i < list.size(); ++i) {
            builder.add((Object)Response.bulkString((Slice)list.get(i)));
        }
        return Response.array((List<Slice>)builder.build());
    }

    public Slice llen(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        LinkedList list;
        Utils.checkArgumentsNumberEquals(params, 1);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            list = data != null ? (LinkedList)Utils.deserializeObject(data) : Lists.newLinkedList();
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        return Response.integer(list.size());
    }

    public Slice lpop(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException, InternalException {
        LinkedList list;
        Utils.checkArgumentsNumberEquals(params, 1);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            if (data == null) {
                return Response.NULL;
            }
            list = (LinkedList)Utils.deserializeObject(data);
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        if (list.isEmpty()) {
            return Response.NULL;
        }
        Slice v = (Slice)list.removeFirst();
        try {
            this.base.rawPut(key, Utils.serializeObject(list), -1L);
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
        return Response.bulkString(v);
    }

    public Slice lindex(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException {
        int index;
        LinkedList list;
        Utils.checkArgumentsNumberEquals(params, 2);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            if (data == null) {
                return Response.NULL;
            }
            list = (LinkedList)Utils.deserializeObject(data);
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        try {
            index = Integer.parseInt(params.get(1).toString());
        }
        catch (NumberFormatException e) {
            throw new WrongValueTypeException("ERR value is not an integer or out of range");
        }
        if (index < 0 && (index = list.size() + index) < 0) {
            return Response.NULL;
        }
        if (index >= list.size()) {
            return Response.NULL;
        }
        return Response.bulkString((Slice)list.get(index));
    }

    public Slice rpush(List<Slice> params) throws WrongNumberOfArgumentsException, WrongValueTypeException, InternalException {
        LinkedList list;
        Utils.checkArgumentsNumberGreater(params, 1);
        Slice key = params.get(0);
        Slice data = this.base.rawGet(key);
        try {
            list = data != null ? (LinkedList)Utils.deserializeObject(data) : Lists.newLinkedList();
        }
        catch (Exception e) {
            throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
        }
        for (int i = 1; i < params.size(); ++i) {
            list.addLast(params.get(i));
        }
        try {
            this.base.rawPut(key, Utils.serializeObject(list), -1L);
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
        return Response.integer(list.size());
    }

    public synchronized Slice execCommand(RedisCommand command) {
        Preconditions.checkArgument((command.getParameters().size() > 0 ? 1 : 0) != 0);
        List<Slice> params = command.getParameters();
        String name = new String(params.get(0).data()).toLowerCase();
        try {
            Method method = this.getClass().getMethod(name, List.class);
            return (Slice)method.invoke((Object)this, params.subList(1, params.size()));
        }
        catch (IllegalAccessException e) {
            throw new NoSuchElementException();
        }
        catch (InvocationTargetException e) {
            Throwable err = e.getTargetException();
            if (err instanceof WrongValueTypeException) {
                return Response.error(err.getMessage());
            }
            if (err instanceof WrongNumberOfArgumentsException) {
                return Response.error(String.format("ERR wrong number of arguments for '%s' command", name));
            }
            return Response.error(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            return Response.error(String.format("ERR unknown or disabled command '%s'", name));
        }
    }
}

