/*
 * Decompiled with CFR 0.152.
 */
package com.github.zxl0714.redismock;

import com.github.zxl0714.redismock.Slice;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RedisBase {
    private final Map<Slice, Slice> base = Maps.newHashMap();
    private final Map<Slice, Long> deadlines = Maps.newHashMap();
    private List<RedisBase> syncBases = Lists.newArrayList();

    public void addSyncBase(RedisBase base) {
        this.syncBases.add(base);
    }

    @Nullable
    public synchronized Slice rawGet(Slice key) {
        Preconditions.checkNotNull((Object)key);
        Long deadline = this.deadlines.get(key);
        if (deadline != null && deadline != -1L && deadline <= System.currentTimeMillis()) {
            this.base.remove(key);
            this.deadlines.remove(key);
            return null;
        }
        return this.base.get(key);
    }

    @Nullable
    public synchronized Long getTTL(Slice key) {
        Preconditions.checkNotNull((Object)key);
        Long deadline = this.deadlines.get(key);
        if (deadline == null) {
            return null;
        }
        if (deadline == -1L) {
            return deadline;
        }
        long now = System.currentTimeMillis();
        if (now < deadline) {
            return deadline - now;
        }
        this.base.remove(key);
        this.deadlines.remove(key);
        return null;
    }

    public synchronized long setTTL(Slice key, long ttl) {
        Preconditions.checkNotNull((Object)key);
        if (this.base.containsKey(key)) {
            this.deadlines.put(key, ttl + System.currentTimeMillis());
            for (RedisBase base : this.syncBases) {
                base.setTTL(key, ttl);
            }
            return 1L;
        }
        return 0L;
    }

    public synchronized long setDeadline(Slice key, long deadline) {
        Preconditions.checkNotNull((Object)key);
        if (this.base.containsKey(key)) {
            this.deadlines.put(key, deadline);
            for (RedisBase base : this.syncBases) {
                base.setDeadline(key, deadline);
            }
            return 1L;
        }
        return 0L;
    }

    public synchronized void rawPut(Slice key, Slice value, @Nullable Long ttl) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        this.base.put(key, value);
        if (ttl != null) {
            if (ttl != -1L) {
                this.deadlines.put(key, ttl + System.currentTimeMillis());
            } else {
                this.deadlines.put(key, -1L);
            }
        }
        for (RedisBase base : this.syncBases) {
            base.rawPut(key, value, ttl);
        }
    }

    public synchronized void del(Slice key) {
        Preconditions.checkNotNull((Object)key);
        this.base.remove(key);
        this.deadlines.remove(key);
        for (RedisBase base : this.syncBases) {
            base.del(key);
        }
    }
}

