/*
 * Decompiled with CFR 0.152.
 */
package com.github.zxl0714.redismock;

import com.github.zxl0714.redismock.RedisCommand;
import com.github.zxl0714.redismock.Slice;
import com.github.zxl0714.redismock.expecptions.EOFException;
import com.github.zxl0714.redismock.expecptions.ParseErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RedisCommandParser {
    private final InputStream messageInput;

    @VisibleForTesting
    RedisCommandParser(String stringInput) {
        this(new ByteArrayInputStream(stringInput.getBytes()));
    }

    @VisibleForTesting
    RedisCommandParser(InputStream messageInput) {
        Preconditions.checkNotNull((Object)messageInput);
        this.messageInput = messageInput;
    }

    @VisibleForTesting
    byte consumeByte() throws EOFException {
        int b;
        try {
            b = this.messageInput.read();
        }
        catch (IOException e) {
            throw new EOFException();
        }
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @VisibleForTesting
    void expectByte(byte c) throws ParseErrorException, EOFException {
        if (this.consumeByte() != c) {
            throw new ParseErrorException();
        }
    }

    @VisibleForTesting
    long consumeLong() throws ParseErrorException {
        long ret = 0L;
        boolean hasLong = false;
        while (true) {
            byte c;
            try {
                c = this.consumeByte();
            }
            catch (EOFException e) {
                throw new ParseErrorException();
            }
            if (c == 13) break;
            if (!RedisCommandParser.isNumber(c)) {
                throw new ParseErrorException();
            }
            ret = ret * 10L + (long)c - 48L;
            hasLong = true;
        }
        if (!hasLong) {
            throw new ParseErrorException();
        }
        return ret;
    }

    @VisibleForTesting
    Slice consumeSlice(long len) throws ParseErrorException {
        ByteArrayDataOutput bo = ByteStreams.newDataOutput();
        for (long i = 0L; i < len; ++i) {
            try {
                bo.write((int)this.consumeByte());
                continue;
            }
            catch (EOFException e) {
                throw new ParseErrorException();
            }
        }
        return new Slice(bo.toByteArray());
    }

    @VisibleForTesting
    long consumeCount() throws ParseErrorException, EOFException {
        this.expectByte((byte)42);
        try {
            long count = this.consumeLong();
            this.expectByte((byte)10);
            return count;
        }
        catch (EOFException e) {
            throw new ParseErrorException();
        }
    }

    @VisibleForTesting
    Slice consumeParameter() throws ParseErrorException {
        try {
            this.expectByte((byte)36);
            long len = this.consumeLong();
            this.expectByte((byte)10);
            Slice para = this.consumeSlice(len);
            this.expectByte((byte)13);
            this.expectByte((byte)10);
            return para;
        }
        catch (EOFException e) {
            throw new ParseErrorException();
        }
    }

    private static boolean isNumber(byte c) {
        return 48 <= c && c <= 57;
    }

    @VisibleForTesting
    static RedisCommand parse(String stringInput) throws ParseErrorException, EOFException {
        Preconditions.checkNotNull((Object)stringInput);
        return RedisCommandParser.parse(new ByteArrayInputStream(stringInput.getBytes()));
    }

    public static RedisCommand parse(InputStream messageInput) throws ParseErrorException, EOFException {
        Preconditions.checkNotNull((Object)messageInput);
        RedisCommandParser parser = new RedisCommandParser(messageInput);
        long count = parser.consumeCount();
        if (count == 0L) {
            throw new ParseErrorException();
        }
        RedisCommand command = new RedisCommand();
        for (long i = 0L; i < count; ++i) {
            command.addParameter(parser.consumeParameter());
        }
        return command;
    }
}

