/*
 * Decompiled with CFR 0.152.
 */
package com.github.zxl0714.redismock;

import com.github.zxl0714.redismock.CommandExecutor;
import com.github.zxl0714.redismock.RedisWorker;
import com.github.zxl0714.redismock.ServiceOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class RedisService
implements Runnable {
    private final ServerSocket server;
    private final CommandExecutor executor;
    private final ServiceOptions options;

    public RedisService(ServerSocket server, CommandExecutor executor, ServiceOptions options) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)options);
        this.server = server;
        this.executor = executor;
        this.options = options;
    }

    @Override
    public void run() {
        while (!this.server.isClosed()) {
            try {
                Socket socket = this.server.accept();
                Thread t = new Thread(new RedisWorker(this.executor, socket, this.options));
                t.start();
            }
            catch (IOException iOException) {}
        }
    }
}

