/*
 * Decompiled with CFR 0.152.
 */
package com.github.zxl0714.redismock;

import com.github.zxl0714.redismock.CommandExecutor;
import com.github.zxl0714.redismock.RedisCommand;
import com.github.zxl0714.redismock.RedisCommandParser;
import com.github.zxl0714.redismock.ServiceOptions;
import com.github.zxl0714.redismock.Slice;
import com.github.zxl0714.redismock.Utils;
import com.github.zxl0714.redismock.expecptions.EOFException;
import com.github.zxl0714.redismock.expecptions.ParseErrorException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class RedisWorker
implements Runnable {
    private final CommandExecutor executor;
    private final Socket socket;
    private final ServiceOptions options;
    private final InputStream in;
    private final OutputStream out;

    public RedisWorker(CommandExecutor executor, Socket socket, ServiceOptions options) throws IOException {
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)socket);
        Preconditions.checkNotNull((Object)options);
        this.executor = executor;
        this.socket = socket;
        this.options = options;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    @Override
    public void run() {
        int count = 0;
        while (true) {
            try {
                do {
                    RedisCommand command = RedisCommandParser.parse(this.in);
                    Slice resp = this.executor.execCommand(command);
                    this.out.write(resp.data());
                    this.out.flush();
                } while (this.options.getCloseSocketAfterSeveralCommands() == 0 || this.options.getCloseSocketAfterSeveralCommands() != ++count);
            }
            catch (IOException e) {
            }
            catch (ParseErrorException e) {
                continue;
            }
            catch (EOFException e) {
                // empty catch block
            }
            break;
        }
        Utils.closeQuietly(this.socket);
        Utils.closeQuietly(this.in);
        Utils.closeQuietly(this.out);
    }
}

