/*
 * Decompiled with CFR 0.152.
 */
package wrm;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Output;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;
import wrm.libsass.SassCompiler;

public abstract class AbstractSassMojo
extends AbstractMojo {
    protected File outputPath;
    protected String inputPath;
    protected String includePath;
    private SassCompiler.OutputStyle outputStyle;
    private boolean generateSourceComments;
    private boolean generateSourceMap;
    private String sourceMapOutputPath;
    private boolean omitSourceMapingUrl;
    private boolean embedSourceMapInCss;
    private boolean embedSourceContentsInSourceMap;
    private SassCompiler.InputSyntax inputSyntax;
    private int precision;
    private boolean enableClasspathAwareImporter;
    protected boolean failOnError;
    private boolean copySourceToOutput;
    protected MavenProject project;
    protected BuildContext buildContext;
    protected SassCompiler compiler;
    private static final Pattern PATTERN_ERROR_JSON_LINE = Pattern.compile("[\"']line[\"'][:\\s]+([0-9]+)");
    private static final Pattern PATTERN_ERROR_JSON_COLUMN = Pattern.compile("[\"']column[\"'][:\\s]+([0-9]+)");

    protected void compile() throws Exception {
        final AtomicInteger errorCount = new AtomicInteger(0);
        final AtomicInteger fileCount = new AtomicInteger(0);
        if (this.inputPath != null) {
            String[] stringArray = this.inputPath.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                final Path root = this.project.getBasedir().toPath().resolve(Paths.get(path, new String[0]));
                String fileExt = this.getFileExtension();
                String globPattern = "glob:{**/,}*." + fileExt;
                this.getLog().debug((CharSequence)("Glob = " + globPattern));
                final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(globPattern);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (matcher.matches(file) && !file.getFileName().toString().startsWith("_")) {
                            fileCount.incrementAndGet();
                            if (!AbstractSassMojo.this.processFile(root, file)) {
                                errorCount.incrementAndGet();
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
                ++n2;
            }
        }
        this.getLog().info((CharSequence)("Compiled " + fileCount + " files"));
        if (errorCount.get() > 0) {
            if (this.failOnError) {
                throw new Exception("Failed with " + errorCount.get() + " errors");
            }
            this.getLog().error((CharSequence)("Failed with " + errorCount.get() + " errors. Continuing due to failOnError=false."));
        }
    }

    protected String getFileExtension() {
        return this.inputSyntax.toString();
    }

    protected void validateConfig() {
        if (!this.generateSourceMap) {
            if (this.embedSourceMapInCss) {
                this.getLog().warn((CharSequence)"embedSourceMapInCSS=true is ignored. Cause: generateSourceMap=false");
            }
            if (this.embedSourceContentsInSourceMap) {
                this.getLog().warn((CharSequence)"embedSourceContentsInSourceMap=true is ignored. Cause: generateSourceMap=false");
            }
        }
    }

    private void setCompileClasspath() {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            List elements = this.project.getCompileClasspathElements();
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected SassCompiler initCompiler() {
        this.setCompileClasspath();
        SassCompiler compiler = new SassCompiler();
        compiler.setEmbedSourceMapInCss(this.embedSourceMapInCss);
        compiler.setEmbedSourceContentsInSourceMap(this.embedSourceContentsInSourceMap);
        compiler.setGenerateSourceComments(this.generateSourceComments);
        compiler.setGenerateSourceMap(this.generateSourceMap);
        compiler.setIncludePaths(this.includePath);
        compiler.setInputSyntax(this.inputSyntax);
        compiler.setOmitSourceMappingUrl(this.omitSourceMapingUrl);
        compiler.setOutputStyle(this.outputStyle);
        compiler.setPrecision(this.precision);
        compiler.setEnableClasspathAwareImporter(this.enableClasspathAwareImporter);
        return compiler;
    }

    protected boolean processFile(Path inputRootPath, Path inputFilePath) throws IOException {
        Output out;
        this.getLog().debug((CharSequence)("Processing File " + inputFilePath));
        Path relativeInputPath = inputRootPath.relativize(inputFilePath);
        Path outputRootPath = this.outputPath.toPath();
        Path outputFilePath = outputRootPath.resolve(relativeInputPath);
        String fileExtension = this.getFileExtension();
        outputFilePath = Paths.get(outputFilePath.toAbsolutePath().toString().replaceFirst("\\." + fileExtension + "$", ".css"), new String[0]);
        Path sourceMapRootPath = Paths.get(this.sourceMapOutputPath, new String[0]);
        Path sourceMapOutputPath = sourceMapRootPath.resolve(relativeInputPath);
        sourceMapOutputPath = Paths.get(sourceMapOutputPath.toAbsolutePath().toString().replaceFirst("\\.scss$", ".css.map"), new String[0]);
        if (this.copySourceToOutput) {
            Path inputOutputPath = outputRootPath.resolve(relativeInputPath);
            inputOutputPath.toFile().mkdirs();
            Files.copy(inputFilePath, inputOutputPath, StandardCopyOption.REPLACE_EXISTING);
            this.buildContext.refresh(inputOutputPath.toFile());
            inputFilePath = inputOutputPath;
        }
        try {
            out = this.compiler.compileFile(inputFilePath.toAbsolutePath().toString(), outputFilePath.toAbsolutePath().toString(), sourceMapOutputPath.toAbsolutePath().toString());
        }
        catch (CompilationException e) {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().debug((Throwable)e);
            String errorJson = e.getErrorJson();
            int line = 0;
            int column = 0;
            if (errorJson != null) {
                Matcher columnMatcher;
                Matcher lineMatcher = PATTERN_ERROR_JSON_LINE.matcher(errorJson);
                if (lineMatcher.find()) {
                    try {
                        line = Integer.parseInt(lineMatcher.group(1));
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException e1) {
                        this.getLog().error((CharSequence)("Failed to parse error json line: " + e1.getMessage()));
                        this.getLog().debug((Throwable)e1);
                    }
                }
                if ((columnMatcher = PATTERN_ERROR_JSON_COLUMN.matcher(errorJson)).find()) {
                    try {
                        column = Integer.parseInt(columnMatcher.group(1));
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException e1) {
                        this.getLog().error((CharSequence)("Failed to parse error json column: " + e1.getMessage()));
                        this.getLog().debug((Throwable)e1);
                    }
                }
            }
            this.buildContext.addMessage(inputFilePath.toFile(), line, column, e.getErrorMessage(), 2, (Throwable)e);
            return false;
        }
        this.getLog().debug((CharSequence)"Compilation finished.");
        this.writeContentToFile(outputFilePath, out.getCss());
        if (out.getSourceMap() != null) {
            this.writeContentToFile(sourceMapOutputPath, out.getSourceMap());
        }
        return true;
    }

    private void writeContentToFile(Path outputFilePath, String content) throws IOException {
        File f = outputFilePath.toFile();
        f.getParentFile().mkdirs();
        f.createNewFile();
        try (OutputStreamWriter os = null;){
            os = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
            os.write(content);
            os.flush();
        }
        this.buildContext.refresh(outputFilePath.toFile());
        this.getLog().debug((CharSequence)("Written to: " + f));
    }
}

