/*
 * Decompiled with CFR 0.152.
 */
package wrm.libsass;

import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import wrm.libsass.Lookup;
import wrm.libsass.Lookups;
import wrm.libsass.WebJarTranslator;

class ClasspathAwareImporter
implements Importer {
    private static final String SCSS_EXT = ".scss";
    private static final String CSS_EXT = ".css";
    private final WebJarTranslator webJarTranslator = new WebJarTranslator();

    ClasspathAwareImporter() {
    }

    @Override
    public Collection<Import> apply(String importStr, Import previous) {
        URI base = previous.getAbsoluteUri();
        URI uri = ClasspathAwareImporter.buildUri(importStr);
        Optional<URI> uriCss = ClasspathAwareImporter.tryBuildUriCss(importStr);
        Stream<Lookup> lookups = Stream.of(() -> Lookups.findLocalFile(base, ClasspathAwareImporter.addUnderscore(uri)), () -> Lookups.findLocalFile(base, uri), () -> uriCss.map(u -> Lookups.findLocalFile(base, u)).orElse(Optional.empty()), () -> Lookups.findResource(ClasspathAwareImporter.addUnderscore(uri)), () -> Lookups.findResource(uri), () -> uriCss.map(Lookups::findResource).orElse(Optional.empty()), () -> Lookups.findResource(ClasspathAwareImporter.addUnderscore(base.resolve(uri))), () -> Lookups.findResource(base.resolve(uri)), () -> uriCss.map(u -> Lookups.findResource(base.resolve((URI)u))).orElse(Optional.empty()), () -> Lookups.findWebJarResource(ClasspathAwareImporter.addUnderscore(uri), this.webJarTranslator), () -> Lookups.findWebJarResource(uri, this.webJarTranslator), () -> uriCss.map(u -> Lookups.findWebJarResource(u, this.webJarTranslator)).orElse(Optional.empty()));
        Optional<Lookup.Result> lookupResult = lookups.map(Lookup::run).filter(Optional::isPresent).map(Optional::get).findFirst();
        return lookupResult.map(r -> r.buildImport(importStr)).map(Collections::singletonList).orElse(null);
    }

    private static URI buildUri(String importStr) {
        String withExtension = importStr.endsWith(SCSS_EXT) ? importStr : String.valueOf(importStr) + SCSS_EXT;
        return URI.create(withExtension);
    }

    private static Optional<URI> tryBuildUriCss(String importStr) {
        return importStr.endsWith(SCSS_EXT) ? Optional.empty() : Optional.of(URI.create(String.valueOf(importStr) + CSS_EXT));
    }

    private static URI addUnderscore(URI source) {
        String sourceStr = source.toString();
        int afterLastSlash = sourceStr.lastIndexOf("/") + 1;
        String withUnderscore = new StringBuilder(sourceStr).insert(afterLastSlash, "_").toString();
        return URI.create(withUnderscore);
    }
}

