/*
 * Decompiled with CFR 0.152.
 */
package wrm.libsass;

import io.bit3.jsass.importer.Import;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Scanner;

@FunctionalInterface
interface Lookup {
    public Optional<Result> run();

    public static class Result {
        private final String absoluteUri;
        private final URL url;

        private Result(String absoluteUri, URL url) {
            this.absoluteUri = absoluteUri;
            this.url = url;
        }

        static Result of(String absoluteUri, URL url) {
            return new Result(absoluteUri, url);
        }

        static Result of(File file) {
            try {
                String absoluteUri = file.getPath();
                URL url = file.toURI().toURL();
                return new Result(absoluteUri, url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        Import buildImport(String importUri) {
            try {
                String contents = Result.read(this.url);
                return new Import(importUri, this.absoluteUri, contents);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private static String read(URL url) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());){
                    return scanner.useDelimiter("\\A").next();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read the url: " + url, e);
            }
        }
    }
}

