package com.gizbel.excel.test;

import java.io.File;
import java.util.List;

import com.gizbel.excel.enums.ExcelFactoryType;
import com.gizbel.excel.factory.ExcelParser;

public class Main {

    public static void main(String[] args) throws Exception {
        ExcelParser parser = new ExcelParser(BeanColumnNameBased.class, ExcelFactoryType.COLUMN_NAME_BASED_EXTRACTION,new File("test/inv.xlsx"));
        parser.setSkipHeader(true);
        List<String> errors = parser.validateFormat();
        if(!errors.isEmpty()){
            for(String error : errors)
            System.out.println(error);
        }
        List<Object> result = parser.parse();
        for (Object obj : result) {
            BeanColumnNameBased bean = (BeanColumnNameBased) obj;
            System.out.println(bean.toString());
            System.out.println();
        }
    }

}
