/*
 * Decompiled with CFR 0.152.
 */
package com.gizbel.excel.factory;

import com.gizbel.excel.annotations.ExcelBean;
import com.gizbel.excel.annotations.ExcelColumnHeader;
import com.gizbel.excel.annotations.ExcelColumnIndex;
import com.gizbel.excel.enums.ExcelFactoryType;
import com.gizbel.excel.factory.Parser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelParser
extends Parser {
    private Class clazz;
    private boolean skipHeader;
    private Map<String, Field> fieldsMap;
    private boolean breakAfterEmptyRow;

    public ExcelParser(Class clazz, ExcelFactoryType excelFactoryType, File file) throws Exception {
        super(excelFactoryType, file);
        this.clazz = clazz;
        this.breakAfterEmptyRow = true;
        if (clazz.isAnnotationPresent(ExcelBean.class)) {
            Field[] fields;
            this.fieldsMap = new HashMap<String, Field>();
            block4: for (Field field : fields = clazz.getDeclaredFields()) {
                switch (this.getExcelFactoryType()) {
                    case COLUMN_INDEX_BASED_EXTRACTION: {
                        this.prepareColumnIndexBasedFieldMap(field);
                        continue block4;
                    }
                    case COLUMN_NAME_BASED_EXTRACTION: {
                        this.prepareColumnHeaderBasedFieldMap(field);
                    }
                }
            }
        } else {
            throw new Exception("Provided class is not annotated with ExcelBean");
        }
    }

    private void prepareColumnIndexBasedFieldMap(Field field) {
        if (field.isAnnotationPresent(ExcelColumnIndex.class)) {
            field.setAccessible(true);
            ExcelColumnIndex column = field.getAnnotation(ExcelColumnIndex.class);
            String key = String.valueOf(column.columnIndex());
            this.fieldsMap.put(key, field);
        }
    }

    private void prepareColumnHeaderBasedFieldMap(Field field) {
        if (field.isAnnotationPresent(ExcelColumnHeader.class)) {
            field.setAccessible(true);
            ExcelColumnHeader column = field.getAnnotation(ExcelColumnHeader.class);
            String key = column.columnHeader();
            this.fieldsMap.put(key, field);
        }
    }

    private String getDataTypeFor(Field field) {
        String dataType = null;
        switch (this.getExcelFactoryType()) {
            case COLUMN_INDEX_BASED_EXTRACTION: {
                ExcelColumnIndex indexColumn = field.getAnnotation(ExcelColumnIndex.class);
                dataType = indexColumn.dataType();
                break;
            }
            case COLUMN_NAME_BASED_EXTRACTION: {
                ExcelColumnHeader headerColumn = field.getAnnotation(ExcelColumnHeader.class);
                dataType = headerColumn.dataType();
            }
        }
        return dataType;
    }

    private String getDefaultValueFor(Field field) {
        String defaultValue = null;
        switch (this.getExcelFactoryType()) {
            case COLUMN_INDEX_BASED_EXTRACTION: {
                ExcelColumnIndex indexColumn = field.getAnnotation(ExcelColumnIndex.class);
                defaultValue = indexColumn.defaultValue();
                break;
            }
            case COLUMN_NAME_BASED_EXTRACTION: {
                ExcelColumnHeader headerColumn = field.getAnnotation(ExcelColumnHeader.class);
                defaultValue = headerColumn.defaultValue();
            }
        }
        return defaultValue;
    }

    private String getExpectedColumnOrIndexFor(Field field) {
        String expectedValue = null;
        switch (this.getExcelFactoryType()) {
            case COLUMN_INDEX_BASED_EXTRACTION: {
                ExcelColumnIndex indexColumn = field.getAnnotation(ExcelColumnIndex.class);
                expectedValue = indexColumn.expectedColumnName();
                break;
            }
            case COLUMN_NAME_BASED_EXTRACTION: {
                ExcelColumnHeader headerColumn = field.getAnnotation(ExcelColumnHeader.class);
                expectedValue = headerColumn.expectedColumnIndex();
            }
        }
        return expectedValue;
    }

    public List<String> validateFormat() {
        if (this.skipHeader) {
            ArrayList<String> errors = new ArrayList<String>();
            for (Map.Entry<String, Field> entry : this.fieldsMap.entrySet()) {
                String key = entry.getKey();
                Field field = entry.getValue();
                String expectedValue = this.getExpectedColumnOrIndexFor(field);
                if (expectedValue == null || expectedValue.isEmpty() || expectedValue.equals(this.getHeadersMap().get(key))) continue;
                switch (this.getExcelFactoryType()) {
                    case COLUMN_INDEX_BASED_EXTRACTION: {
                        errors.add("Expected Column Header mismatch at column " + key + ", Expected column is \"" + expectedValue + "\", found is \"" + this.getHeadersMap().get(key) + "\"");
                        break;
                    }
                    case COLUMN_NAME_BASED_EXTRACTION: {
                        errors.add("Expected Column Header mismatch for header " + key + ", Expected column index is \"" + expectedValue + "\", found at index \"" + this.getHeadersMap().get(key) + "\"");
                    }
                }
            }
            return errors;
        }
        return null;
    }

    public List<Object> parse() throws InvalidFormatException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, ParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        Sheet sheet = this.getWorkbook().getSheetAt(0);
        if (this.getExcelFactoryType() == ExcelFactoryType.COLUMN_NAME_BASED_EXTRACTION) {
            Row firstRow = sheet.getRow(0);
            for (Cell column : firstRow) {
                Field field = this.fieldsMap.get(column.getStringCellValue());
                if (field == null) continue;
                this.fieldsMap.remove(column.getStringCellValue());
                this.fieldsMap.put(String.valueOf(column.getColumnIndex()), field);
            }
        }
        for (Row row : sheet) {
            if (this.getExcelFactoryType() != ExcelFactoryType.COLUMN_INDEX_BASED_EXTRACTION ? this.getExcelFactoryType() == ExcelFactoryType.COLUMN_NAME_BASED_EXTRACTION && row.getRowNum() == 0 : row.getRowNum() == 0 && this.skipHeader) continue;
            if (!this.isEmptyRow(row)) {
                Object beanObj = this.getBeanForARow(row);
                result.add(beanObj);
                continue;
            }
            if (!this.breakAfterEmptyRow) continue;
            break;
        }
        return result;
    }

    public Object getBeanForARow(Row row) throws InstantiationException, IllegalAccessException, IllegalArgumentException, ParseException {
        Object classObj = this.clazz.newInstance();
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            if (cell != null) {
                String value = this.getCellValue(cell);
                this.setCellValueBasedOnDesiredExcelFactoryType(classObj, value, i);
                continue;
            }
            this.setCellValueBasedOnDesiredExcelFactoryType(classObj, null, i);
        }
        return classObj;
    }

    private void setCellValueBasedOnDesiredExcelFactoryType(Object classObj, String columnValue, int columnIndex) throws IllegalArgumentException, IllegalAccessException, ParseException {
        Field field = this.fieldsMap.get(String.valueOf(columnIndex));
        if (field != null) {
            if (columnValue == null || columnValue.trim().isEmpty()) {
                columnValue = this.getDefaultValueFor(field);
            }
            if (columnValue != null && !columnValue.trim().isEmpty()) {
                String dataType;
                switch (dataType = this.getDataTypeFor(field)) {
                    case "int": {
                        field.set(classObj, Integer.parseInt(columnValue));
                        break;
                    }
                    case "long": {
                        field.set(classObj, Long.parseLong(columnValue));
                        break;
                    }
                    case "bool": {
                        field.set(classObj, Boolean.parseBoolean(columnValue));
                        break;
                    }
                    case "double": {
                        Double data = Double.parseDouble(columnValue);
                        field.set(classObj, data);
                        break;
                    }
                    case "date": {
                        field.set(classObj, this.dateParser(columnValue));
                        break;
                    }
                    default: {
                        field.set(classObj, columnValue);
                    }
                }
            }
        }
    }

    public boolean isBreakAfterEmptyRow() {
        return this.breakAfterEmptyRow;
    }

    public void setBreakAfterEmptyRow(boolean breakAfterEmptyRow) {
        this.breakAfterEmptyRow = breakAfterEmptyRow;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public void setSkipHeader(boolean skipHeader) {
        this.skipHeader = skipHeader;
    }
}

