/*
 * Decompiled with CFR 0.152.
 */
package com.gizbel.excel.factory;

import com.gizbel.excel.enums.ExcelFactoryType;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class Parser {
    private ExcelFactoryType excelFactoryType;
    private Map<String, String> headersMap;
    private Workbook workbook;

    public Parser(ExcelFactoryType excelFactoryType, File file) throws Exception {
        this.excelFactoryType = excelFactoryType;
        this.headersMap = new HashMap<String, String>();
        this.workbook = WorkbookFactory.create((File)file);
        Sheet sheet = this.workbook.getSheetAt(0);
        Row firstRow = sheet.getRow(0);
        for (Cell column : firstRow) {
            String columnIndex = String.valueOf(column.getColumnIndex());
            String columnValue = this.getCellValue(column);
            switch (this.excelFactoryType) {
                case COLUMN_INDEX_BASED_EXTRACTION: {
                    this.headersMap.put(columnIndex, columnValue);
                    break;
                }
                case COLUMN_NAME_BASED_EXTRACTION: {
                    this.headersMap.put(columnValue, columnIndex);
                }
            }
        }
    }

    protected String getCellValue(Cell cell) {
        if (cell != null) {
            if (cell.getCellType() == 0) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    cell.setCellType(1);
                    cell.setCellValue(new SimpleDateFormat("dd-MM-yyyy").format(date));
                } else {
                    cell.setCellType(1);
                }
            } else {
                cell.setCellType(1);
            }
            return cell.getStringCellValue() == null ? null : cell.getStringCellValue().trim();
        }
        return null;
    }

    protected Date dateParser(String value) {
        if (value != null && !value.isEmpty()) {
            String[] formats = new String[]{"dd-MM-yyyy"};
            try {
                Date date = DateUtils.parseDate((String)value, (String[])formats);
                return date;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected boolean isEmptyRow(Row row) {
        boolean isEmptyRow = true;
        for (int cellNum = row.getFirstCellNum(); cellNum < row.getLastCellNum(); ++cellNum) {
            Cell cell = row.getCell(cellNum);
            if (cell == null || cell.getCellType() == 3 || !StringUtils.isNotBlank((CharSequence)cell.toString())) continue;
            isEmptyRow = false;
        }
        return isEmptyRow;
    }

    protected Map<String, String> getHeadersMap() {
        return this.headersMap;
    }

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    protected ExcelFactoryType getExcelFactoryType() {
        return this.excelFactoryType;
    }
}

