/*
 * Decompiled with CFR 0.152.
 */
package com.globalmentor.calendar.calculator;

import com.globalmentor.java.Conditions;
import com.globalmentor.model.Count;
import com.globalmentor.model.Range;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class CalendarCalculator {
    public static SortedMap<LocalDate, Count> getDayCounts(Set<Range<LocalDate>> ranges, boolean isRangeLowerInclusive) {
        TreeMap<LocalDate, Count> dayCounts = new TreeMap<LocalDate, Count>();
        for (Range<LocalDate> range : ranges) {
            LocalDate upperBoundDate = (LocalDate)range.getUpperBound();
            LocalDate rangeDate = (LocalDate)range.getLowerBound();
            Conditions.checkArgument((rangeDate.compareTo(upperBoundDate) <= 0 ? 1 : 0) != 0, (String)"Calendar range %s cannot be greater than %s.", (Object[])new Object[]{rangeDate, upperBoundDate});
            if (!isRangeLowerInclusive) {
                dayCounts.computeIfAbsent(rangeDate, __ -> new Count(0L));
                rangeDate = rangeDate.plusDays(1L);
            }
            while (rangeDate.compareTo(upperBoundDate) <= 0) {
                Count.incrementCounterMapCount(dayCounts, (Object)rangeDate);
                rangeDate = rangeDate.plusDays(1L);
            }
        }
        return dayCounts;
    }

    public static SortedMap<LocalDate, Long> getDayTotals(LocalDate date, int windowSize, Map<LocalDate, Count> dayCounts) {
        return CalendarCalculator.getDayTotals(date, null, windowSize, windowSize, dayCounts);
    }

    public static SortedMap<LocalDate, Long> getDayTotals(LocalDate date, LocalDate resetDate, int windowSize, Map<LocalDate, Count> dayCounts) {
        return CalendarCalculator.getDayTotals(date, resetDate, windowSize, windowSize, dayCounts);
    }

    public static SortedMap<LocalDate, Long> getDayTotals(LocalDate date, LocalDate resetDate, int windowSize, int historyCount, Map<LocalDate, Count> dayCounts) {
        LocalDate day = date;
        TreeMap<LocalDate, Long> dayTotals = new TreeMap<LocalDate, Long>();
        for (int i = 0; i < historyCount; ++i) {
            LocalDate totalDate = day;
            long total = 0L;
            for (int j = 0; j < windowSize; ++j) {
                Count currentDayCount = dayCounts.get(totalDate);
                if (currentDayCount != null) {
                    total += currentDayCount.getCount();
                }
                if (resetDate != null && MonthDay.from(totalDate).equals(MonthDay.from(resetDate))) break;
                totalDate = totalDate.minusDays(1L);
            }
            dayTotals.put(day, total);
            day = day.minusDays(1L);
        }
        return dayTotals;
    }
}

