/*
 * Decompiled with CFR 0.152.
 */
package com.globo.globodns.client;

import com.globo.globodns.client.GloboDns;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockGloboDns
extends GloboDns {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockGloboDns.class);

    public MockGloboDns() {
        super((HttpTransport)new SimulatedHttpTransport());
        this.setBaseUrl("http://example.com");
    }

    @Override
    public String buildToken() {
        LOGGER.info("Generating new authentication token");
        return "fake-auth-token";
    }

    public void registerFakeRequest(HttpMethod method, String url, String expectedResult) {
        this.registerFakeRequest(method, url, 200, expectedResult);
    }

    public void registerFakeRequest(HttpMethod method, String url, int statusCode, String expectedResult) {
        ((SimulatedHttpTransport)this.getHttpTransport()).registerFakeRequest(method, this.getBaseUrl() + url, statusCode, expectedResult);
    }

    public int numberOfRequests(HttpMethod method, String url) {
        return ((SimulatedHttpTransport)this.getHttpTransport()).numberOfRequests(method.name(), url);
    }

    public int totalNumberOfRequests() {
        return ((SimulatedHttpTransport)this.getHttpTransport()).totalNumberOfRequests();
    }

    public static class CounterMockLowLevelHttpResponse
    extends MockLowLevelHttpResponse {
        int numberOfRequests = 0;
    }

    private static class SimulatedHttpTransport
    extends MockHttpTransport {
        private int totalNumberOfRequests = 0;
        final Map<String, CounterMockLowLevelHttpResponse> urlVsResponse = new HashMap<String, CounterMockLowLevelHttpResponse>();

        private SimulatedHttpTransport() {
        }

        public void registerFakeRequest(HttpMethod method, String url, int statusCode, String expectedResult) {
            String key = method.name() + " " + url;
            CounterMockLowLevelHttpResponse fakeResponse = new CounterMockLowLevelHttpResponse();
            fakeResponse.setStatusCode(statusCode);
            fakeResponse.setContent(expectedResult);
            this.urlVsResponse.put(key, fakeResponse);
        }

        public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
            MockLowLevelHttpRequest request = (MockLowLevelHttpRequest)super.buildRequest(method, url);
            CounterMockLowLevelHttpResponse response = this.urlVsResponse.get(method.toUpperCase() + " " + url);
            if (response == null) {
                throw new RuntimeException("Invalid url: " + url);
            }
            request.setResponse((MockLowLevelHttpResponse)response);
            ++response.numberOfRequests;
            ++this.totalNumberOfRequests;
            return request;
        }

        public int totalNumberOfRequests() {
            return this.totalNumberOfRequests;
        }

        public int numberOfRequests(String method, String url) {
            CounterMockLowLevelHttpResponse response = this.urlVsResponse.get(method.toUpperCase() + " " + url);
            if (response == null) {
                throw new RuntimeException("Invalid url: " + url);
            }
            return response.numberOfRequests;
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

