/*
 * Decompiled with CFR 0.152.
 */
package com.globo.globodns.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.globo.globodns.client.AbstractAPI;
import com.globo.globodns.client.GloboDns;
import com.globo.globodns.client.GloboDnsException;
import com.globo.globodns.client.model.Authentication;
import com.globo.globodns.client.model.GloboDnsRoot;
import com.globo.globodns.client.model.User;
import com.google.api.client.http.HttpRequest;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Trace;
import java.lang.reflect.Type;
import java.util.List;

public class AuthAPI
extends AbstractAPI<Authentication> {
    public AuthAPI(GloboDns transport) {
        super(transport);
    }

    @Override
    protected Type getType() {
        return new TypeReference<Authentication>(){}.getType();
    }

    @Override
    protected Type getListType() {
        return new TypeReference<List<Authentication>>(){}.getType();
    }

    @Override
    protected void interceptRequest(HttpRequest request) {
        request.setUnsuccessfulResponseHandler(null);
    }

    @Trace(dispatcher=true)
    public Authentication signIn(String email, String password) throws GloboDnsException {
        NewRelic.setTransactionName(null, (String)"/globodns/signin");
        User user = new User(email, password);
        GloboDnsRoot payload = new GloboDnsRoot();
        payload.set("user", (Object)user);
        GloboDnsRoot globoDnsRoot = this.post("/users/sign_in.json", (Object)payload, false);
        if (globoDnsRoot == null) {
            throw new GloboDnsException("Invalid authentication response");
        }
        Authentication auth = (Authentication)((Object)globoDnsRoot.getFirstObject());
        return auth;
    }
}

