/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.globusltd.recyclerview.AdapterDatasourceObserver;
import com.globusltd.recyclerview.DatasourceSwappable;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.datasource.DatasourceOwner;
import com.globusltd.recyclerview.datasource.DatasourceProxy;
import com.globusltd.recyclerview.datasource.Datasources;
import com.globusltd.recyclerview.diff.DiffCallbackFactory;
import java.util.List;

@MainThread
public abstract class Adapter<E, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements DatasourceSwappable<E> {
    @NonNull
    private final DatasourceOwner<E> mDatasourceOwner;

    public Adapter() {
        this(Datasources.empty());
    }

    public Adapter(@NonNull Datasource<? extends E> datasource) {
        this(datasource, null);
    }

    public Adapter(@NonNull Datasource<? extends E> datasource, @Nullable DiffCallbackFactory<E> diffCallbackFactory) {
        DatasourceProxy<? extends E> datasourceProxy = new DatasourceProxy<E>(datasource, diffCallbackFactory);
        AdapterDatasourceObserver datasourceObserver = new AdapterDatasourceObserver(this);
        this.mDatasourceOwner = new DatasourceOwner<E>(datasourceProxy, datasourceObserver);
    }

    @CallSuper
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mDatasourceOwner.onAttachedToRecyclerView(recyclerView);
    }

    @CallSuper
    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mDatasourceOwner.onDetachedFromRecyclerView(recyclerView);
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @Override
    @Nullable
    public final Datasource<? extends E> swap(@NonNull Datasource<? extends E> datasource) {
        return this.mDatasourceOwner.swap(datasource);
    }

    @NonNull
    public Datasource<? extends E> getDatasource() {
        return this.mDatasourceOwner.getDatasource();
    }

    public int getItemCount() {
        return this.getDatasource().size();
    }

    public final VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return this.onCreateViewHolder(inflater, parent, viewType);
    }

    @NonNull
    public abstract VH onCreateViewHolder(@NonNull LayoutInflater var1, @NonNull ViewGroup var2, int var3);

    public final void onBindViewHolder(VH holder, int position) {
        E item = this.getDatasource().get(position);
        this.onBindViewHolder(holder, item, position);
    }

    public abstract void onBindViewHolder(@NonNull VH var1, @NonNull E var2, int var3);

    public final void onBindViewHolder(VH holder, int position, List<Object> payloads) {
        E item = this.getDatasource().get(position);
        this.onBindViewHolder(holder, item, position, payloads);
    }

    public void onBindViewHolder(@NonNull VH holder, @NonNull E item, int position, List<Object> payloads) {
        this.onBindViewHolder(holder, item, position);
    }
}

