/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import com.globusltd.recyclerview.datasource.DatasourceObserver;

public class AdapterDatasourceObserver
extends DatasourceObserver {
    @NonNull
    private final RecyclerView.Adapter<?> mAdapter;

    AdapterDatasourceObserver(@NonNull RecyclerView.Adapter<?> adapter) {
        this.mAdapter = adapter;
    }

    @Override
    public void onChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onItemRangeChanged(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount, @Nullable Object payload) {
        this.mAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
    }

    @Override
    public void onItemRangeInserted(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        this.mAdapter.notifyItemRangeInserted(positionStart, itemCount);
    }

    @Override
    public void onItemRangeRemoved(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        this.mAdapter.notifyItemRangeRemoved(positionStart, itemCount);
    }

    @Override
    public void onItemMoved(@IntRange(from=0L) int fromPosition, @IntRange(from=0L) int toPosition) {
        this.mAdapter.notifyItemMoved(fromPosition, toPosition);
    }
}

