/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview;

import android.graphics.Rect;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.globusltd.recyclerview.RecyclerViewOwner;
import com.globusltd.recyclerview.ViewHolderObserver;
import com.globusltd.recyclerview.util.Observable;

@MainThread
public class ViewHolderTracker
extends RecyclerViewOwner {
    @NonNull
    private final ViewHolderObservable mViewHolderObservable = new ViewHolderObservable();
    @Nullable
    private OnChildAttachStateChangeListener mOnChildAttachStateChangeListener;
    @Nullable
    private RecyclerView.ItemDecoration mItemDecoration;

    public void registerViewHolderObserver(@NonNull ViewHolderObserver viewHolderObserver) {
        this.mViewHolderObservable.registerObserver(viewHolderObserver);
    }

    public void unregisterViewHolderObserver(@NonNull ViewHolderObserver viewHolderObserver) {
        this.mViewHolderObservable.unregisterObserver(viewHolderObserver);
    }

    @Override
    protected void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mOnChildAttachStateChangeListener = new OnChildAttachStateChangeListener(recyclerView);
        this.mOnChildAttachStateChangeListener.onAttachedToRecyclerView();
        recyclerView.addOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this.mOnChildAttachStateChangeListener);
        this.mItemDecoration = new ItemDecoration();
        recyclerView.addItemDecoration(this.mItemDecoration);
    }

    @Override
    protected void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        if (this.mOnChildAttachStateChangeListener != null) {
            recyclerView.removeOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this.mOnChildAttachStateChangeListener);
            this.mOnChildAttachStateChangeListener.onDetachedFromRecyclerView();
            this.mOnChildAttachStateChangeListener = null;
        }
        if (this.mItemDecoration != null) {
            recyclerView.removeItemDecoration(this.mItemDecoration);
            this.mItemDecoration = null;
        }
    }

    private static class ViewHolderObservable
    extends Observable<ViewHolderObserver> {
        private ViewHolderObservable() {
        }

        void notifyAttached(@NonNull RecyclerView.ViewHolder viewHolder) {
            int size = this.mObservers.size();
            for (int i = size - 1; i >= 0; --i) {
                ViewHolderObserver behavior = (ViewHolderObserver)this.mObservers.get(i);
                behavior.onAttached(viewHolder);
            }
        }

        void notifyPositionChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
            int size = this.mObservers.size();
            for (int i = size - 1; i >= 0; --i) {
                ViewHolderObserver behavior = (ViewHolderObserver)this.mObservers.get(i);
                behavior.onPositionChanged(viewHolder);
            }
        }

        void notifyChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
            int size = this.mObservers.size();
            for (int i = size - 1; i >= 0; --i) {
                ViewHolderObserver behavior = (ViewHolderObserver)this.mObservers.get(i);
                behavior.onChanged(viewHolder);
            }
        }

        void notifyDetached(@NonNull RecyclerView.ViewHolder viewHolder) {
            int size = this.mObservers.size();
            for (int i = size - 1; i >= 0; --i) {
                ViewHolderObserver behavior = (ViewHolderObserver)this.mObservers.get(i);
                behavior.onDetached(viewHolder);
            }
        }
    }

    private class ItemDecoration
    extends RecyclerView.ItemDecoration {
        private ItemDecoration() {
        }

        public void getItemOffsets(Rect outRect, View itemView, RecyclerView parent, RecyclerView.State state) {
            if (state.isMeasuring()) {
                return;
            }
            RecyclerView.ViewHolder viewHolder = parent.findContainingViewHolder(itemView);
            if (viewHolder == null) {
                return;
            }
            int position = viewHolder.getAdapterPosition();
            if (state.isPreLayout()) {
                int oldPosition = viewHolder.getOldPosition();
                if (position > -1 && position != oldPosition) {
                    ViewHolderTracker.this.mViewHolderObservable.notifyPositionChanged(viewHolder);
                }
            } else {
                ViewHolderTracker.this.mViewHolderObservable.notifyChanged(viewHolder);
            }
        }
    }

    private class OnChildAttachStateChangeListener
    implements RecyclerView.OnChildAttachStateChangeListener {
        @NonNull
        private final RecyclerView mHostView;

        private OnChildAttachStateChangeListener(RecyclerView recyclerView) {
            this.mHostView = recyclerView;
        }

        void onAttachedToRecyclerView() {
            int childCount = this.mHostView.getChildCount();
            for (int index = 0; index < childCount; ++index) {
                View child = this.mHostView.getChildAt(index);
                this.onChildViewAttachedToWindow(child);
            }
        }

        public void onChildViewAttachedToWindow(View view) {
            RecyclerView.ViewHolder viewHolder = this.mHostView.findContainingViewHolder(view);
            if (viewHolder != null) {
                ViewHolderTracker.this.mViewHolderObservable.notifyAttached(viewHolder);
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
            RecyclerView.ViewHolder viewHolder = this.mHostView.findContainingViewHolder(view);
            if (viewHolder != null) {
                ViewHolderTracker.this.mViewHolderObservable.notifyDetached(viewHolder);
            }
        }

        void onDetachedFromRecyclerView() {
            int childCount = this.mHostView.getChildCount();
            for (int index = 0; index < childCount; ++index) {
                View child = this.mHostView.getChildAt(index);
                this.onChildViewAttachedToWindow(child);
            }
        }
    }
}

