/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.choice;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.view.ActionMode;

public abstract class ActionModeCompat {
    @NonNull
    public static ActionModeCompat from(@NonNull Fragment fragment) {
        return new FragmentActionModeCompat(fragment);
    }

    @NonNull
    public static ActionModeCompat from(@NonNull AppCompatActivity activity) {
        return new ActivityActionModeCompat(activity);
    }

    private ActionModeCompat() {
    }

    @Nullable
    public abstract ActionMode startActionMode(@NonNull ActionMode.Callback var1);

    private static class ActivityActionModeCompat
    extends ActionModeCompat {
        @NonNull
        private final AppCompatActivity mActivity;

        ActivityActionModeCompat(@NonNull AppCompatActivity activity) {
            this.mActivity = activity;
        }

        @Override
        @Nullable
        public ActionMode startActionMode(@NonNull ActionMode.Callback callback) {
            return this.mActivity.startSupportActionMode(callback);
        }
    }

    private static class FragmentActionModeCompat
    extends ActionModeCompat {
        @NonNull
        private final Fragment mFragment;

        FragmentActionModeCompat(@NonNull Fragment fragment) {
            this.mFragment = fragment;
        }

        @Override
        @Nullable
        public ActionMode startActionMode(@NonNull ActionMode.Callback callback) {
            FragmentActivity activity = this.mFragment.getActivity();
            if (activity instanceof AppCompatActivity) {
                AppCompatActivity appCompatActivity = (AppCompatActivity)activity;
                return appCompatActivity.startSupportActionMode(callback);
            }
            throw new IllegalStateException("Your activity should extend AppCompatActivity.");
        }
    }
}

