/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.choice;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.globusltd.collections.LongArrayList;
import com.globusltd.recyclerview.choice.ObservableChoiceMode;
import com.globusltd.recyclerview.choice.SimpleChoiceModeListener;

public class MultipleChoiceMode
extends ObservableChoiceMode {
    private static final String KEY_MULTIPLE_CHOICE_MODE = "multiple_choice_mode";
    private static final String KEY_CHECKED_IDS = "checked_ids";
    @Nullable
    private SimpleChoiceModeListener mChoiceModeListener;
    @NonNull
    private final LongArrayList mCheckedIds = new LongArrayList();

    public MultipleChoiceMode() {
        this(null);
    }

    public MultipleChoiceMode(@Nullable Bundle savedInstanceState) {
        Bundle state;
        Bundle bundle = state = savedInstanceState != null ? savedInstanceState.getBundle(KEY_MULTIPLE_CHOICE_MODE) : null;
        if (state != null) {
            LongArrayList checkedIdStates = (LongArrayList)state.getParcelable(KEY_CHECKED_IDS);
            if (checkedIdStates == null) {
                throw new IllegalArgumentException("Did you put checked id states to the saved state?");
            }
            int count = checkedIdStates.size();
            this.mCheckedIds.clear();
            for (int i = 0; i < count; ++i) {
                this.mCheckedIds.add(checkedIdStates.get(i));
            }
        }
    }

    public void setChoiceModeListener(@Nullable SimpleChoiceModeListener listener) {
        this.mChoiceModeListener = listener;
    }

    @Override
    public boolean requiresStableIds() {
        return true;
    }

    @Override
    public boolean requiresLongpress() {
        return false;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public int getCheckedItemCount() {
        return this.mCheckedIds.size();
    }

    @Override
    public boolean isItemChecked(long itemId) {
        return this.mCheckedIds.contains(itemId);
    }

    @Override
    public void setItemChecked(long itemId, boolean checked) {
        this.setItemCheckedInternal(itemId, checked, false);
    }

    private void setItemCheckedInternal(long itemId, boolean checked, boolean fromUser) {
        int indexOf = this.mCheckedIds.indexOf(itemId);
        if (indexOf > -1) {
            this.mCheckedIds.removeAt(indexOf);
        }
        if (checked) {
            this.mCheckedIds.add(itemId);
        }
        if (this.mChoiceModeListener != null) {
            this.mChoiceModeListener.onItemCheckedStateChanged(itemId, checked, fromUser);
        }
        this.notifyItemCheckedChanged(itemId, fromUser);
    }

    @NonNull
    public LongArrayList getCheckedItems() {
        return this.mCheckedIds;
    }

    @Override
    public void clearChoices() {
        this.mCheckedIds.clear();
        this.notifyAllItemsCheckedChanged(false);
    }

    @Override
    public boolean onClick(long itemId) {
        boolean checked = !this.isItemChecked(itemId);
        this.setItemCheckedInternal(itemId, checked, true);
        return false;
    }

    @Override
    public boolean onLongClick(long itemId) {
        return true;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        Bundle state = new Bundle();
        state.putParcelable(KEY_CHECKED_IDS, (Parcelable)new LongArrayList(this.mCheckedIds));
        outState.putBundle(KEY_MULTIPLE_CHOICE_MODE, state);
    }
}

