/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.choice;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import com.globusltd.collections.LongArrayList;
import com.globusltd.recyclerview.choice.ActionModeCompat;
import com.globusltd.recyclerview.choice.ChoiceModeObserver;
import com.globusltd.recyclerview.choice.ModalChoiceModeListener;
import com.globusltd.recyclerview.choice.ObservableChoiceMode;

public class MultipleModalChoiceMode
extends ObservableChoiceMode {
    private static final String KEY_MULTIPLE_CHOICE_MODE = "multiple_choice_mode";
    private static final String KEY_CHECKED_IDS = "checked_ids";
    @NonNull
    private final ActionModeCompat mActionModeCompat;
    @NonNull
    private final ActionModeCallbacks mActionModeCallbacks;
    private boolean mStartOnSingleTapEnabled = false;
    private boolean mFinishActionModeOnClearEnabled = true;
    @Nullable
    private ActionMode mActionMode;
    @NonNull
    private final LongArrayList mCheckedIds;

    public MultipleModalChoiceMode(@NonNull ActionModeCompat actionModeCompat, @NonNull ModalChoiceModeListener listener) {
        this(actionModeCompat, listener, null);
    }

    public MultipleModalChoiceMode(@NonNull ActionModeCompat actionModeCompat, @NonNull ModalChoiceModeListener listener, @Nullable Bundle savedInstanceState) {
        Bundle state;
        this.mActionModeCompat = actionModeCompat;
        this.mActionModeCallbacks = new ActionModeCallbacks(listener);
        this.mCheckedIds = new LongArrayList();
        Bundle bundle = state = savedInstanceState != null ? savedInstanceState.getBundle(KEY_MULTIPLE_CHOICE_MODE) : null;
        if (state != null) {
            LongArrayList checkedIdStates = (LongArrayList)state.getParcelable(KEY_CHECKED_IDS);
            if (checkedIdStates == null) {
                throw new IllegalArgumentException("Did you put checked id states to the saved state?");
            }
            int count = checkedIdStates.size();
            this.mCheckedIds.clear();
            for (int i = 0; i < count; ++i) {
                this.mCheckedIds.add(checkedIdStates.get(i));
            }
        }
    }

    public void setStartOnSingleTapEnabled(boolean enabled) {
        this.mStartOnSingleTapEnabled = enabled;
    }

    public void setFinishActionModeOnClearEnabled(boolean enabled) {
        this.mFinishActionModeOnClearEnabled = enabled;
    }

    @Override
    public boolean requiresStableIds() {
        return true;
    }

    @Override
    public boolean requiresLongpress() {
        return true;
    }

    @Override
    public boolean isActivated() {
        return this.mActionMode != null;
    }

    @Override
    @IntRange(from=0L, to=1L)
    public int getCheckedItemCount() {
        return this.mCheckedIds.size();
    }

    @Override
    public boolean isItemChecked(long itemId) {
        return this.mCheckedIds.contains(itemId);
    }

    @Override
    public void setItemChecked(long itemId, boolean checked) {
        this.setItemCheckedInternal(itemId, checked, false);
    }

    private void setItemCheckedInternal(long itemId, boolean checked, boolean fromUser) {
        int indexOf;
        if (checked) {
            this.startActionMode(fromUser);
        }
        if ((indexOf = this.mCheckedIds.indexOf(itemId)) > -1) {
            this.mCheckedIds.removeAt(indexOf);
        }
        if (checked) {
            this.mCheckedIds.add(itemId);
        }
        if (this.mActionMode != null) {
            this.mActionModeCallbacks.onItemCheckedStateChanged(this.mActionMode, itemId, checked, fromUser);
        }
        this.notifyItemCheckedChanged(itemId, fromUser);
    }

    @NonNull
    public LongArrayList getCheckedItems() {
        return this.mCheckedIds;
    }

    @Override
    public void clearChoices() {
        this.clearChoicesInternal(false);
    }

    private void clearChoicesInternal(boolean fromDestroyCallback) {
        this.mCheckedIds.clear();
        this.notifyAllItemsCheckedChanged(false);
        if (!fromDestroyCallback && this.mActionMode != null) {
            if (this.mFinishActionModeOnClearEnabled) {
                this.mActionMode.finish();
            } else {
                this.mActionMode.invalidate();
            }
        }
    }

    @Override
    public boolean onClick(long itemId) {
        if (this.mActionMode == null && this.mStartOnSingleTapEnabled) {
            this.setItemCheckedInternal(itemId, true, true);
            return true;
        }
        if (this.mActionMode != null) {
            boolean checked = !this.isItemChecked(itemId);
            this.setItemCheckedInternal(itemId, checked, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onLongClick(long itemId) {
        this.setItemCheckedInternal(itemId, true, true);
        return true;
    }

    @Override
    public void registerChoiceModeObserver(@NonNull ChoiceModeObserver observer) {
        super.registerChoiceModeObserver(observer);
        if (!this.mCheckedIds.isEmpty()) {
            this.startActionMode(false);
        }
    }

    private void startActionMode(boolean fromUser) {
        if (this.mActionMode == null) {
            this.mActionMode = this.mActionModeCompat.startActionMode(this.mActionModeCallbacks);
            this.notifyAllItemsCheckedChanged(fromUser);
        }
    }

    @Override
    public void unregisterChoiceModeObserver(@NonNull ChoiceModeObserver observer) {
        super.unregisterChoiceModeObserver(observer);
        this.finishActionMode();
    }

    public void finish() {
        this.clearChoicesInternal(true);
        this.finishActionMode();
    }

    private void finishActionMode() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        Bundle state = new Bundle();
        state.putParcelable(KEY_CHECKED_IDS, (Parcelable)new LongArrayList(this.mCheckedIds));
        outState.putBundle(KEY_MULTIPLE_CHOICE_MODE, state);
    }

    private class ActionModeCallbacks
    implements ModalChoiceModeListener {
        private boolean mFinishFromUser;
        @NonNull
        private ModalChoiceModeListener mModalChoiceModeListener;

        private ActionModeCallbacks(ModalChoiceModeListener listener) {
            this.mModalChoiceModeListener = listener;
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            return this.mModalChoiceModeListener.onCreateActionMode(mode, menu);
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mModalChoiceModeListener.onPrepareActionMode(mode, menu);
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mModalChoiceModeListener.onActionItemClicked(mode, item);
        }

        public void onDestroyActionMode(ActionMode mode) {
            MultipleModalChoiceMode.this.clearChoicesInternal(true);
            this.mModalChoiceModeListener.onDestroyActionMode(mode);
            MultipleModalChoiceMode.this.mActionMode = null;
            MultipleModalChoiceMode.this.notifyAllItemsCheckedChanged(this.mFinishFromUser);
            this.mFinishFromUser = false;
        }

        @Override
        public void onItemCheckedStateChanged(@NonNull ActionMode mode, long itemId, boolean checked, boolean fromUser) {
            mode.invalidate();
            this.mModalChoiceModeListener.onItemCheckedStateChanged(mode, itemId, checked, fromUser);
            if (MultipleModalChoiceMode.this.mFinishActionModeOnClearEnabled && MultipleModalChoiceMode.this.getCheckedItemCount() == 0) {
                this.mFinishFromUser = true;
                mode.finish();
            }
        }
    }
}

